//megafunction wizard: %Altera SOPC Builder%
//GENERATION: STANDARD
//VERSION: WM1.0


//Legal Notice: (C)2012 Altera Corporation. All rights reserved.  Your
//use of Altera Corporation's design tools, logic functions and other
//software and tools, and its AMPP partner logic functions, and any
//output files any of the foregoing (including device programming or
//simulation files), and any associated documentation or information are
//expressly subject to the terms and conditions of the Altera Program
//License Subscription Agreement or other applicable license agreement,
//including, without limitation, that your use is for the sole purpose
//of programming logic devices manufactured by Altera and sold by Altera
//or its authorized distributors.  Please refer to the applicable
//agreement for further details.

// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module cpu_jtag_debug_module_arbitrator (
                                          // inputs:
                                           clk,
                                           cpu_data_master_address_to_slave,
                                           cpu_data_master_byteenable,
                                           cpu_data_master_debugaccess,
                                           cpu_data_master_read,
                                           cpu_data_master_waitrequest,
                                           cpu_data_master_write,
                                           cpu_data_master_writedata,
                                           cpu_instruction_master_address_to_slave,
                                           cpu_instruction_master_latency_counter,
                                           cpu_instruction_master_read,
                                           cpu_jtag_debug_module_readdata,
                                           cpu_jtag_debug_module_resetrequest,
                                           reset_n,

                                          // outputs:
                                           cpu_data_master_granted_cpu_jtag_debug_module,
                                           cpu_data_master_qualified_request_cpu_jtag_debug_module,
                                           cpu_data_master_read_data_valid_cpu_jtag_debug_module,
                                           cpu_data_master_requests_cpu_jtag_debug_module,
                                           cpu_instruction_master_granted_cpu_jtag_debug_module,
                                           cpu_instruction_master_qualified_request_cpu_jtag_debug_module,
                                           cpu_instruction_master_read_data_valid_cpu_jtag_debug_module,
                                           cpu_instruction_master_requests_cpu_jtag_debug_module,
                                           cpu_jtag_debug_module_address,
                                           cpu_jtag_debug_module_begintransfer,
                                           cpu_jtag_debug_module_byteenable,
                                           cpu_jtag_debug_module_chipselect,
                                           cpu_jtag_debug_module_debugaccess,
                                           cpu_jtag_debug_module_readdata_from_sa,
                                           cpu_jtag_debug_module_reset_n,
                                           cpu_jtag_debug_module_resetrequest_from_sa,
                                           cpu_jtag_debug_module_write,
                                           cpu_jtag_debug_module_writedata,
                                           d1_cpu_jtag_debug_module_end_xfer
                                        )
;

  output           cpu_data_master_granted_cpu_jtag_debug_module;
  output           cpu_data_master_qualified_request_cpu_jtag_debug_module;
  output           cpu_data_master_read_data_valid_cpu_jtag_debug_module;
  output           cpu_data_master_requests_cpu_jtag_debug_module;
  output           cpu_instruction_master_granted_cpu_jtag_debug_module;
  output           cpu_instruction_master_qualified_request_cpu_jtag_debug_module;
  output           cpu_instruction_master_read_data_valid_cpu_jtag_debug_module;
  output           cpu_instruction_master_requests_cpu_jtag_debug_module;
  output  [  8: 0] cpu_jtag_debug_module_address;
  output           cpu_jtag_debug_module_begintransfer;
  output  [  3: 0] cpu_jtag_debug_module_byteenable;
  output           cpu_jtag_debug_module_chipselect;
  output           cpu_jtag_debug_module_debugaccess;
  output  [ 31: 0] cpu_jtag_debug_module_readdata_from_sa;
  output           cpu_jtag_debug_module_reset_n;
  output           cpu_jtag_debug_module_resetrequest_from_sa;
  output           cpu_jtag_debug_module_write;
  output  [ 31: 0] cpu_jtag_debug_module_writedata;
  output           d1_cpu_jtag_debug_module_end_xfer;
  input            clk;
  input   [ 20: 0] cpu_data_master_address_to_slave;
  input   [  3: 0] cpu_data_master_byteenable;
  input            cpu_data_master_debugaccess;
  input            cpu_data_master_read;
  input            cpu_data_master_waitrequest;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input   [ 20: 0] cpu_instruction_master_address_to_slave;
  input            cpu_instruction_master_latency_counter;
  input            cpu_instruction_master_read;
  input   [ 31: 0] cpu_jtag_debug_module_readdata;
  input            cpu_jtag_debug_module_resetrequest;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_cpu_jtag_debug_module;
  wire             cpu_data_master_qualified_request_cpu_jtag_debug_module;
  wire             cpu_data_master_read_data_valid_cpu_jtag_debug_module;
  wire             cpu_data_master_requests_cpu_jtag_debug_module;
  wire             cpu_data_master_saved_grant_cpu_jtag_debug_module;
  wire             cpu_instruction_master_arbiterlock;
  wire             cpu_instruction_master_arbiterlock2;
  wire             cpu_instruction_master_continuerequest;
  wire             cpu_instruction_master_granted_cpu_jtag_debug_module;
  wire             cpu_instruction_master_qualified_request_cpu_jtag_debug_module;
  wire             cpu_instruction_master_read_data_valid_cpu_jtag_debug_module;
  wire             cpu_instruction_master_requests_cpu_jtag_debug_module;
  wire             cpu_instruction_master_saved_grant_cpu_jtag_debug_module;
  wire    [  8: 0] cpu_jtag_debug_module_address;
  wire             cpu_jtag_debug_module_allgrants;
  wire             cpu_jtag_debug_module_allow_new_arb_cycle;
  wire             cpu_jtag_debug_module_any_bursting_master_saved_grant;
  wire             cpu_jtag_debug_module_any_continuerequest;
  reg     [  1: 0] cpu_jtag_debug_module_arb_addend;
  wire             cpu_jtag_debug_module_arb_counter_enable;
  reg     [  1: 0] cpu_jtag_debug_module_arb_share_counter;
  wire    [  1: 0] cpu_jtag_debug_module_arb_share_counter_next_value;
  wire    [  1: 0] cpu_jtag_debug_module_arb_share_set_values;
  wire    [  1: 0] cpu_jtag_debug_module_arb_winner;
  wire             cpu_jtag_debug_module_arbitration_holdoff_internal;
  wire             cpu_jtag_debug_module_beginbursttransfer_internal;
  wire             cpu_jtag_debug_module_begins_xfer;
  wire             cpu_jtag_debug_module_begintransfer;
  wire    [  3: 0] cpu_jtag_debug_module_byteenable;
  wire             cpu_jtag_debug_module_chipselect;
  wire    [  3: 0] cpu_jtag_debug_module_chosen_master_double_vector;
  wire    [  1: 0] cpu_jtag_debug_module_chosen_master_rot_left;
  wire             cpu_jtag_debug_module_debugaccess;
  wire             cpu_jtag_debug_module_end_xfer;
  wire             cpu_jtag_debug_module_firsttransfer;
  wire    [  1: 0] cpu_jtag_debug_module_grant_vector;
  wire             cpu_jtag_debug_module_in_a_read_cycle;
  wire             cpu_jtag_debug_module_in_a_write_cycle;
  wire    [  1: 0] cpu_jtag_debug_module_master_qreq_vector;
  wire             cpu_jtag_debug_module_non_bursting_master_requests;
  wire    [ 31: 0] cpu_jtag_debug_module_readdata_from_sa;
  reg              cpu_jtag_debug_module_reg_firsttransfer;
  wire             cpu_jtag_debug_module_reset_n;
  wire             cpu_jtag_debug_module_resetrequest_from_sa;
  reg     [  1: 0] cpu_jtag_debug_module_saved_chosen_master_vector;
  reg              cpu_jtag_debug_module_slavearbiterlockenable;
  wire             cpu_jtag_debug_module_slavearbiterlockenable2;
  wire             cpu_jtag_debug_module_unreg_firsttransfer;
  wire             cpu_jtag_debug_module_waits_for_read;
  wire             cpu_jtag_debug_module_waits_for_write;
  wire             cpu_jtag_debug_module_write;
  wire    [ 31: 0] cpu_jtag_debug_module_writedata;
  reg              d1_cpu_jtag_debug_module_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_cpu_jtag_debug_module;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  reg              last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module;
  reg              last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module;
  wire    [ 20: 0] shifted_address_to_cpu_jtag_debug_module_from_cpu_data_master;
  wire    [ 20: 0] shifted_address_to_cpu_jtag_debug_module_from_cpu_instruction_master;
  wire             wait_for_cpu_jtag_debug_module_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~cpu_jtag_debug_module_end_xfer;
    end


  assign cpu_jtag_debug_module_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_cpu_jtag_debug_module | cpu_instruction_master_qualified_request_cpu_jtag_debug_module));
  //assign cpu_jtag_debug_module_readdata_from_sa = cpu_jtag_debug_module_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign cpu_jtag_debug_module_readdata_from_sa = cpu_jtag_debug_module_readdata;

  assign cpu_data_master_requests_cpu_jtag_debug_module = ({cpu_data_master_address_to_slave[20 : 11] , 11'b0} == 21'h100800) & (cpu_data_master_read | cpu_data_master_write);
  //cpu_jtag_debug_module_arb_share_counter set values, which is an e_mux
  assign cpu_jtag_debug_module_arb_share_set_values = 1;

  //cpu_jtag_debug_module_non_bursting_master_requests mux, which is an e_mux
  assign cpu_jtag_debug_module_non_bursting_master_requests = cpu_data_master_requests_cpu_jtag_debug_module |
    cpu_instruction_master_requests_cpu_jtag_debug_module |
    cpu_data_master_requests_cpu_jtag_debug_module |
    cpu_instruction_master_requests_cpu_jtag_debug_module;

  //cpu_jtag_debug_module_any_bursting_master_saved_grant mux, which is an e_mux
  assign cpu_jtag_debug_module_any_bursting_master_saved_grant = 0;

  //cpu_jtag_debug_module_arb_share_counter_next_value assignment, which is an e_assign
  assign cpu_jtag_debug_module_arb_share_counter_next_value = cpu_jtag_debug_module_firsttransfer ? (cpu_jtag_debug_module_arb_share_set_values - 1) : |cpu_jtag_debug_module_arb_share_counter ? (cpu_jtag_debug_module_arb_share_counter - 1) : 0;

  //cpu_jtag_debug_module_allgrants all slave grants, which is an e_mux
  assign cpu_jtag_debug_module_allgrants = (|cpu_jtag_debug_module_grant_vector) |
    (|cpu_jtag_debug_module_grant_vector) |
    (|cpu_jtag_debug_module_grant_vector) |
    (|cpu_jtag_debug_module_grant_vector);

  //cpu_jtag_debug_module_end_xfer assignment, which is an e_assign
  assign cpu_jtag_debug_module_end_xfer = ~(cpu_jtag_debug_module_waits_for_read | cpu_jtag_debug_module_waits_for_write);

  //end_xfer_arb_share_counter_term_cpu_jtag_debug_module arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_cpu_jtag_debug_module = cpu_jtag_debug_module_end_xfer & (~cpu_jtag_debug_module_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //cpu_jtag_debug_module_arb_share_counter arbitration counter enable, which is an e_assign
  assign cpu_jtag_debug_module_arb_counter_enable = (end_xfer_arb_share_counter_term_cpu_jtag_debug_module & cpu_jtag_debug_module_allgrants) | (end_xfer_arb_share_counter_term_cpu_jtag_debug_module & ~cpu_jtag_debug_module_non_bursting_master_requests);

  //cpu_jtag_debug_module_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_jtag_debug_module_arb_share_counter <= 0;
      else if (cpu_jtag_debug_module_arb_counter_enable)
          cpu_jtag_debug_module_arb_share_counter <= cpu_jtag_debug_module_arb_share_counter_next_value;
    end


  //cpu_jtag_debug_module_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_jtag_debug_module_slavearbiterlockenable <= 0;
      else if ((|cpu_jtag_debug_module_master_qreq_vector & end_xfer_arb_share_counter_term_cpu_jtag_debug_module) | (end_xfer_arb_share_counter_term_cpu_jtag_debug_module & ~cpu_jtag_debug_module_non_bursting_master_requests))
          cpu_jtag_debug_module_slavearbiterlockenable <= |cpu_jtag_debug_module_arb_share_counter_next_value;
    end


  //cpu/data_master cpu/jtag_debug_module arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = cpu_jtag_debug_module_slavearbiterlockenable & cpu_data_master_continuerequest;

  //cpu_jtag_debug_module_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign cpu_jtag_debug_module_slavearbiterlockenable2 = |cpu_jtag_debug_module_arb_share_counter_next_value;

  //cpu/data_master cpu/jtag_debug_module arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = cpu_jtag_debug_module_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //cpu/instruction_master cpu/jtag_debug_module arbiterlock, which is an e_assign
  assign cpu_instruction_master_arbiterlock = cpu_jtag_debug_module_slavearbiterlockenable & cpu_instruction_master_continuerequest;

  //cpu/instruction_master cpu/jtag_debug_module arbiterlock2, which is an e_assign
  assign cpu_instruction_master_arbiterlock2 = cpu_jtag_debug_module_slavearbiterlockenable2 & cpu_instruction_master_continuerequest;

  //cpu/instruction_master granted cpu/jtag_debug_module last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module <= 0;
      else 
        last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module <= cpu_instruction_master_saved_grant_cpu_jtag_debug_module ? 1 : (cpu_jtag_debug_module_arbitration_holdoff_internal | ~cpu_instruction_master_requests_cpu_jtag_debug_module) ? 0 : last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module;
    end


  //cpu_instruction_master_continuerequest continued request, which is an e_mux
  assign cpu_instruction_master_continuerequest = last_cycle_cpu_instruction_master_granted_slave_cpu_jtag_debug_module & cpu_instruction_master_requests_cpu_jtag_debug_module;

  //cpu_jtag_debug_module_any_continuerequest at least one master continues requesting, which is an e_mux
  assign cpu_jtag_debug_module_any_continuerequest = cpu_instruction_master_continuerequest |
    cpu_data_master_continuerequest;

  assign cpu_data_master_qualified_request_cpu_jtag_debug_module = cpu_data_master_requests_cpu_jtag_debug_module & ~(((~cpu_data_master_waitrequest) & cpu_data_master_write) | cpu_instruction_master_arbiterlock);
  //cpu_jtag_debug_module_writedata mux, which is an e_mux
  assign cpu_jtag_debug_module_writedata = cpu_data_master_writedata;

  assign cpu_instruction_master_requests_cpu_jtag_debug_module = (({cpu_instruction_master_address_to_slave[20 : 11] , 11'b0} == 21'h100800) & (cpu_instruction_master_read)) & cpu_instruction_master_read;
  //cpu/data_master granted cpu/jtag_debug_module last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module <= 0;
      else 
        last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module <= cpu_data_master_saved_grant_cpu_jtag_debug_module ? 1 : (cpu_jtag_debug_module_arbitration_holdoff_internal | ~cpu_data_master_requests_cpu_jtag_debug_module) ? 0 : last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module;
    end


  //cpu_data_master_continuerequest continued request, which is an e_mux
  assign cpu_data_master_continuerequest = last_cycle_cpu_data_master_granted_slave_cpu_jtag_debug_module & cpu_data_master_requests_cpu_jtag_debug_module;

  assign cpu_instruction_master_qualified_request_cpu_jtag_debug_module = cpu_instruction_master_requests_cpu_jtag_debug_module & ~((cpu_instruction_master_read & ((cpu_instruction_master_latency_counter != 0))) | cpu_data_master_arbiterlock);
  //local readdatavalid cpu_instruction_master_read_data_valid_cpu_jtag_debug_module, which is an e_mux
  assign cpu_instruction_master_read_data_valid_cpu_jtag_debug_module = cpu_instruction_master_granted_cpu_jtag_debug_module & cpu_instruction_master_read & ~cpu_jtag_debug_module_waits_for_read;

  //allow new arb cycle for cpu/jtag_debug_module, which is an e_assign
  assign cpu_jtag_debug_module_allow_new_arb_cycle = ~cpu_data_master_arbiterlock & ~cpu_instruction_master_arbiterlock;

  //cpu/instruction_master assignment into master qualified-requests vector for cpu/jtag_debug_module, which is an e_assign
  assign cpu_jtag_debug_module_master_qreq_vector[0] = cpu_instruction_master_qualified_request_cpu_jtag_debug_module;

  //cpu/instruction_master grant cpu/jtag_debug_module, which is an e_assign
  assign cpu_instruction_master_granted_cpu_jtag_debug_module = cpu_jtag_debug_module_grant_vector[0];

  //cpu/instruction_master saved-grant cpu/jtag_debug_module, which is an e_assign
  assign cpu_instruction_master_saved_grant_cpu_jtag_debug_module = cpu_jtag_debug_module_arb_winner[0] && cpu_instruction_master_requests_cpu_jtag_debug_module;

  //cpu/data_master assignment into master qualified-requests vector for cpu/jtag_debug_module, which is an e_assign
  assign cpu_jtag_debug_module_master_qreq_vector[1] = cpu_data_master_qualified_request_cpu_jtag_debug_module;

  //cpu/data_master grant cpu/jtag_debug_module, which is an e_assign
  assign cpu_data_master_granted_cpu_jtag_debug_module = cpu_jtag_debug_module_grant_vector[1];

  //cpu/data_master saved-grant cpu/jtag_debug_module, which is an e_assign
  assign cpu_data_master_saved_grant_cpu_jtag_debug_module = cpu_jtag_debug_module_arb_winner[1] && cpu_data_master_requests_cpu_jtag_debug_module;

  //cpu/jtag_debug_module chosen-master double-vector, which is an e_assign
  assign cpu_jtag_debug_module_chosen_master_double_vector = {cpu_jtag_debug_module_master_qreq_vector, cpu_jtag_debug_module_master_qreq_vector} & ({~cpu_jtag_debug_module_master_qreq_vector, ~cpu_jtag_debug_module_master_qreq_vector} + cpu_jtag_debug_module_arb_addend);

  //stable onehot encoding of arb winner
  assign cpu_jtag_debug_module_arb_winner = (cpu_jtag_debug_module_allow_new_arb_cycle & | cpu_jtag_debug_module_grant_vector) ? cpu_jtag_debug_module_grant_vector : cpu_jtag_debug_module_saved_chosen_master_vector;

  //saved cpu_jtag_debug_module_grant_vector, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_jtag_debug_module_saved_chosen_master_vector <= 0;
      else if (cpu_jtag_debug_module_allow_new_arb_cycle)
          cpu_jtag_debug_module_saved_chosen_master_vector <= |cpu_jtag_debug_module_grant_vector ? cpu_jtag_debug_module_grant_vector : cpu_jtag_debug_module_saved_chosen_master_vector;
    end


  //onehot encoding of chosen master
  assign cpu_jtag_debug_module_grant_vector = {(cpu_jtag_debug_module_chosen_master_double_vector[1] | cpu_jtag_debug_module_chosen_master_double_vector[3]),
    (cpu_jtag_debug_module_chosen_master_double_vector[0] | cpu_jtag_debug_module_chosen_master_double_vector[2])};

  //cpu/jtag_debug_module chosen master rotated left, which is an e_assign
  assign cpu_jtag_debug_module_chosen_master_rot_left = (cpu_jtag_debug_module_arb_winner << 1) ? (cpu_jtag_debug_module_arb_winner << 1) : 1;

  //cpu/jtag_debug_module's addend for next-master-grant
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_jtag_debug_module_arb_addend <= 1;
      else if (|cpu_jtag_debug_module_grant_vector)
          cpu_jtag_debug_module_arb_addend <= cpu_jtag_debug_module_end_xfer? cpu_jtag_debug_module_chosen_master_rot_left : cpu_jtag_debug_module_grant_vector;
    end


  assign cpu_jtag_debug_module_begintransfer = cpu_jtag_debug_module_begins_xfer;
  //cpu_jtag_debug_module_reset_n assignment, which is an e_assign
  assign cpu_jtag_debug_module_reset_n = reset_n;

  //assign cpu_jtag_debug_module_resetrequest_from_sa = cpu_jtag_debug_module_resetrequest so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign cpu_jtag_debug_module_resetrequest_from_sa = cpu_jtag_debug_module_resetrequest;

  assign cpu_jtag_debug_module_chipselect = cpu_data_master_granted_cpu_jtag_debug_module | cpu_instruction_master_granted_cpu_jtag_debug_module;
  //cpu_jtag_debug_module_firsttransfer first transaction, which is an e_assign
  assign cpu_jtag_debug_module_firsttransfer = cpu_jtag_debug_module_begins_xfer ? cpu_jtag_debug_module_unreg_firsttransfer : cpu_jtag_debug_module_reg_firsttransfer;

  //cpu_jtag_debug_module_unreg_firsttransfer first transaction, which is an e_assign
  assign cpu_jtag_debug_module_unreg_firsttransfer = ~(cpu_jtag_debug_module_slavearbiterlockenable & cpu_jtag_debug_module_any_continuerequest);

  //cpu_jtag_debug_module_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_jtag_debug_module_reg_firsttransfer <= 1'b1;
      else if (cpu_jtag_debug_module_begins_xfer)
          cpu_jtag_debug_module_reg_firsttransfer <= cpu_jtag_debug_module_unreg_firsttransfer;
    end


  //cpu_jtag_debug_module_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign cpu_jtag_debug_module_beginbursttransfer_internal = cpu_jtag_debug_module_begins_xfer;

  //cpu_jtag_debug_module_arbitration_holdoff_internal arbitration_holdoff, which is an e_assign
  assign cpu_jtag_debug_module_arbitration_holdoff_internal = cpu_jtag_debug_module_begins_xfer & cpu_jtag_debug_module_firsttransfer;

  //cpu_jtag_debug_module_write assignment, which is an e_mux
  assign cpu_jtag_debug_module_write = cpu_data_master_granted_cpu_jtag_debug_module & cpu_data_master_write;

  assign shifted_address_to_cpu_jtag_debug_module_from_cpu_data_master = cpu_data_master_address_to_slave;
  //cpu_jtag_debug_module_address mux, which is an e_mux
  assign cpu_jtag_debug_module_address = (cpu_data_master_granted_cpu_jtag_debug_module)? (shifted_address_to_cpu_jtag_debug_module_from_cpu_data_master >> 2) :
    (shifted_address_to_cpu_jtag_debug_module_from_cpu_instruction_master >> 2);

  assign shifted_address_to_cpu_jtag_debug_module_from_cpu_instruction_master = cpu_instruction_master_address_to_slave;
  //d1_cpu_jtag_debug_module_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_cpu_jtag_debug_module_end_xfer <= 1;
      else 
        d1_cpu_jtag_debug_module_end_xfer <= cpu_jtag_debug_module_end_xfer;
    end


  //cpu_jtag_debug_module_waits_for_read in a cycle, which is an e_mux
  assign cpu_jtag_debug_module_waits_for_read = cpu_jtag_debug_module_in_a_read_cycle & cpu_jtag_debug_module_begins_xfer;

  //cpu_jtag_debug_module_in_a_read_cycle assignment, which is an e_assign
  assign cpu_jtag_debug_module_in_a_read_cycle = (cpu_data_master_granted_cpu_jtag_debug_module & cpu_data_master_read) | (cpu_instruction_master_granted_cpu_jtag_debug_module & cpu_instruction_master_read);

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = cpu_jtag_debug_module_in_a_read_cycle;

  //cpu_jtag_debug_module_waits_for_write in a cycle, which is an e_mux
  assign cpu_jtag_debug_module_waits_for_write = cpu_jtag_debug_module_in_a_write_cycle & 0;

  //cpu_jtag_debug_module_in_a_write_cycle assignment, which is an e_assign
  assign cpu_jtag_debug_module_in_a_write_cycle = cpu_data_master_granted_cpu_jtag_debug_module & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = cpu_jtag_debug_module_in_a_write_cycle;

  assign wait_for_cpu_jtag_debug_module_counter = 0;
  //cpu_jtag_debug_module_byteenable byte enable port mux, which is an e_mux
  assign cpu_jtag_debug_module_byteenable = (cpu_data_master_granted_cpu_jtag_debug_module)? cpu_data_master_byteenable :
    -1;

  //debugaccess mux, which is an e_mux
  assign cpu_jtag_debug_module_debugaccess = (cpu_data_master_granted_cpu_jtag_debug_module)? cpu_data_master_debugaccess :
    0;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //cpu/jtag_debug_module enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end


  //grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_data_master_granted_cpu_jtag_debug_module + cpu_instruction_master_granted_cpu_jtag_debug_module > 1)
        begin
          $write("%0d ns: > 1 of grant signals are active simultaneously", $time);
          $stop;
        end
    end


  //saved_grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_data_master_saved_grant_cpu_jtag_debug_module + cpu_instruction_master_saved_grant_cpu_jtag_debug_module > 1)
        begin
          $write("%0d ns: > 1 of saved_grant signals are active simultaneously", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module cpu_data_master_arbitrator (
                                    // inputs:
                                     clk,
                                     cpu_data_master_address,
                                     cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0,
                                     cpu_data_master_granted_cpu_jtag_debug_module,
                                     cpu_data_master_granted_pio_hex_s1,
                                     cpu_data_master_granted_pio_key_s1,
                                     cpu_data_master_granted_pio_left_s1,
                                     cpu_data_master_granted_pio_pingpong_s1,
                                     cpu_data_master_granted_pio_right_s1,
                                     cpu_data_master_granted_pio_sw_s1,
                                     cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0,
                                     cpu_data_master_qualified_request_cpu_jtag_debug_module,
                                     cpu_data_master_qualified_request_pio_hex_s1,
                                     cpu_data_master_qualified_request_pio_key_s1,
                                     cpu_data_master_qualified_request_pio_left_s1,
                                     cpu_data_master_qualified_request_pio_pingpong_s1,
                                     cpu_data_master_qualified_request_pio_right_s1,
                                     cpu_data_master_qualified_request_pio_sw_s1,
                                     cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0,
                                     cpu_data_master_read,
                                     cpu_data_master_read_data_valid_cpu_jtag_debug_module,
                                     cpu_data_master_read_data_valid_pio_hex_s1,
                                     cpu_data_master_read_data_valid_pio_key_s1,
                                     cpu_data_master_read_data_valid_pio_left_s1,
                                     cpu_data_master_read_data_valid_pio_pingpong_s1,
                                     cpu_data_master_read_data_valid_pio_right_s1,
                                     cpu_data_master_read_data_valid_pio_sw_s1,
                                     cpu_data_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0,
                                     cpu_data_master_requests_cpu_jtag_debug_module,
                                     cpu_data_master_requests_pio_hex_s1,
                                     cpu_data_master_requests_pio_key_s1,
                                     cpu_data_master_requests_pio_left_s1,
                                     cpu_data_master_requests_pio_pingpong_s1,
                                     cpu_data_master_requests_pio_right_s1,
                                     cpu_data_master_requests_pio_sw_s1,
                                     cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0,
                                     cpu_data_master_write,
                                     cpu_data_master_writedata,
                                     cpu_jtag_debug_module_readdata_from_sa,
                                     d1_cpu_jtag_debug_module_end_xfer,
                                     d1_pio_hex_s1_end_xfer,
                                     d1_pio_key_s1_end_xfer,
                                     d1_pio_left_s1_end_xfer,
                                     d1_pio_pingpong_s1_end_xfer,
                                     d1_pio_right_s1_end_xfer,
                                     d1_pio_sw_s1_end_xfer,
                                     d1_sram_16bit_512k_0_avalon_slave_0_end_xfer,
                                     pio_hex_s1_readdata_from_sa,
                                     pio_key_s1_irq_from_sa,
                                     pio_key_s1_readdata_from_sa,
                                     pio_left_s1_readdata_from_sa,
                                     pio_pingpong_s1_readdata_from_sa,
                                     pio_right_s1_readdata_from_sa,
                                     pio_sw_s1_readdata_from_sa,
                                     reset_n,
                                     sram_16bit_512k_0_avalon_slave_0_readdata_from_sa,
                                     sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0,

                                    // outputs:
                                     cpu_data_master_address_to_slave,
                                     cpu_data_master_dbs_address,
                                     cpu_data_master_dbs_write_16,
                                     cpu_data_master_irq,
                                     cpu_data_master_no_byte_enables_and_last_term,
                                     cpu_data_master_readdata,
                                     cpu_data_master_waitrequest
                                  )
;

  output  [ 20: 0] cpu_data_master_address_to_slave;
  output  [  1: 0] cpu_data_master_dbs_address;
  output  [ 15: 0] cpu_data_master_dbs_write_16;
  output  [ 31: 0] cpu_data_master_irq;
  output           cpu_data_master_no_byte_enables_and_last_term;
  output  [ 31: 0] cpu_data_master_readdata;
  output           cpu_data_master_waitrequest;
  input            clk;
  input   [ 20: 0] cpu_data_master_address;
  input   [  1: 0] cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0;
  input            cpu_data_master_granted_cpu_jtag_debug_module;
  input            cpu_data_master_granted_pio_hex_s1;
  input            cpu_data_master_granted_pio_key_s1;
  input            cpu_data_master_granted_pio_left_s1;
  input            cpu_data_master_granted_pio_pingpong_s1;
  input            cpu_data_master_granted_pio_right_s1;
  input            cpu_data_master_granted_pio_sw_s1;
  input            cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0;
  input            cpu_data_master_qualified_request_cpu_jtag_debug_module;
  input            cpu_data_master_qualified_request_pio_hex_s1;
  input            cpu_data_master_qualified_request_pio_key_s1;
  input            cpu_data_master_qualified_request_pio_left_s1;
  input            cpu_data_master_qualified_request_pio_pingpong_s1;
  input            cpu_data_master_qualified_request_pio_right_s1;
  input            cpu_data_master_qualified_request_pio_sw_s1;
  input            cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0;
  input            cpu_data_master_read;
  input            cpu_data_master_read_data_valid_cpu_jtag_debug_module;
  input            cpu_data_master_read_data_valid_pio_hex_s1;
  input            cpu_data_master_read_data_valid_pio_key_s1;
  input            cpu_data_master_read_data_valid_pio_left_s1;
  input            cpu_data_master_read_data_valid_pio_pingpong_s1;
  input            cpu_data_master_read_data_valid_pio_right_s1;
  input            cpu_data_master_read_data_valid_pio_sw_s1;
  input            cpu_data_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0;
  input            cpu_data_master_requests_cpu_jtag_debug_module;
  input            cpu_data_master_requests_pio_hex_s1;
  input            cpu_data_master_requests_pio_key_s1;
  input            cpu_data_master_requests_pio_left_s1;
  input            cpu_data_master_requests_pio_pingpong_s1;
  input            cpu_data_master_requests_pio_right_s1;
  input            cpu_data_master_requests_pio_sw_s1;
  input            cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input   [ 31: 0] cpu_jtag_debug_module_readdata_from_sa;
  input            d1_cpu_jtag_debug_module_end_xfer;
  input            d1_pio_hex_s1_end_xfer;
  input            d1_pio_key_s1_end_xfer;
  input            d1_pio_left_s1_end_xfer;
  input            d1_pio_pingpong_s1_end_xfer;
  input            d1_pio_right_s1_end_xfer;
  input            d1_pio_sw_s1_end_xfer;
  input            d1_sram_16bit_512k_0_avalon_slave_0_end_xfer;
  input   [ 31: 0] pio_hex_s1_readdata_from_sa;
  input            pio_key_s1_irq_from_sa;
  input   [ 31: 0] pio_key_s1_readdata_from_sa;
  input   [ 31: 0] pio_left_s1_readdata_from_sa;
  input   [ 31: 0] pio_pingpong_s1_readdata_from_sa;
  input   [ 31: 0] pio_right_s1_readdata_from_sa;
  input   [ 31: 0] pio_sw_s1_readdata_from_sa;
  input            reset_n;
  input   [ 15: 0] sram_16bit_512k_0_avalon_slave_0_readdata_from_sa;
  input            sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0;

  wire    [ 20: 0] cpu_data_master_address_to_slave;
  reg     [  1: 0] cpu_data_master_dbs_address;
  wire    [  1: 0] cpu_data_master_dbs_increment;
  wire    [ 15: 0] cpu_data_master_dbs_write_16;
  wire    [ 31: 0] cpu_data_master_irq;
  reg              cpu_data_master_no_byte_enables_and_last_term;
  wire    [ 31: 0] cpu_data_master_readdata;
  wire             cpu_data_master_run;
  reg              cpu_data_master_waitrequest;
  reg     [ 15: 0] dbs_16_reg_segment_0;
  wire             dbs_count_enable;
  wire             dbs_counter_overflow;
  wire             last_dbs_term_and_run;
  wire    [  1: 0] next_dbs_address;
  wire    [ 15: 0] p1_dbs_16_reg_segment_0;
  wire             pre_dbs_count_enable;
  wire             r_0;
  wire             r_1;
  //r_0 master_run cascaded wait assignment, which is an e_assign
  assign r_0 = 1 & (cpu_data_master_qualified_request_cpu_jtag_debug_module | ~cpu_data_master_requests_cpu_jtag_debug_module) & (cpu_data_master_granted_cpu_jtag_debug_module | ~cpu_data_master_qualified_request_cpu_jtag_debug_module) & ((~cpu_data_master_qualified_request_cpu_jtag_debug_module | ~cpu_data_master_read | (1 & 1 & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_cpu_jtag_debug_module | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_pio_hex_s1 | ~cpu_data_master_requests_pio_hex_s1) & ((~cpu_data_master_qualified_request_pio_hex_s1 | ~cpu_data_master_read | (1 & 1 & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_pio_hex_s1 | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_pio_key_s1 | ~cpu_data_master_requests_pio_key_s1) & ((~cpu_data_master_qualified_request_pio_key_s1 | ~cpu_data_master_read | (1 & 1 & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_pio_key_s1 | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_pio_left_s1 | ~cpu_data_master_requests_pio_left_s1) & ((~cpu_data_master_qualified_request_pio_left_s1 | ~cpu_data_master_read | (1 & 1 & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_pio_left_s1 | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_pio_pingpong_s1 | ~cpu_data_master_requests_pio_pingpong_s1) & ((~cpu_data_master_qualified_request_pio_pingpong_s1 | ~cpu_data_master_read | (1 & 1 & cpu_data_master_read)));

  //cascaded wait assignment, which is an e_assign
  assign cpu_data_master_run = r_0 & r_1;

  //r_1 master_run cascaded wait assignment, which is an e_assign
  assign r_1 = ((~cpu_data_master_qualified_request_pio_pingpong_s1 | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_pio_right_s1 | ~cpu_data_master_requests_pio_right_s1) & ((~cpu_data_master_qualified_request_pio_right_s1 | ~cpu_data_master_read | (1 & 1 & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_pio_right_s1 | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & ((~cpu_data_master_qualified_request_pio_sw_s1 | ~cpu_data_master_read | (1 & 1 & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_pio_sw_s1 | ~cpu_data_master_write | (1 & cpu_data_master_write))) & 1 & (cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0 | (cpu_data_master_write & !cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0 & cpu_data_master_dbs_address[1]) | ~cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0) & (cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0 | ~cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0) & ((~cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0 | ~cpu_data_master_read | (1 & 1 & (cpu_data_master_dbs_address[1]) & cpu_data_master_read))) & ((~cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0 | ~cpu_data_master_write | (1 & ~d1_sram_16bit_512k_0_avalon_slave_0_end_xfer & (cpu_data_master_dbs_address[1]) & cpu_data_master_write)));

  //optimize select-logic by passing only those address bits which matter.
  assign cpu_data_master_address_to_slave = cpu_data_master_address[20 : 0];

  //cpu/data_master readdata mux, which is an e_mux
  assign cpu_data_master_readdata = ({32 {~cpu_data_master_requests_cpu_jtag_debug_module}} | cpu_jtag_debug_module_readdata_from_sa) &
    ({32 {~cpu_data_master_requests_pio_hex_s1}} | pio_hex_s1_readdata_from_sa) &
    ({32 {~cpu_data_master_requests_pio_key_s1}} | pio_key_s1_readdata_from_sa) &
    ({32 {~cpu_data_master_requests_pio_left_s1}} | pio_left_s1_readdata_from_sa) &
    ({32 {~cpu_data_master_requests_pio_pingpong_s1}} | pio_pingpong_s1_readdata_from_sa) &
    ({32 {~cpu_data_master_requests_pio_right_s1}} | pio_right_s1_readdata_from_sa) &
    ({32 {~cpu_data_master_requests_pio_sw_s1}} | pio_sw_s1_readdata_from_sa) &
    ({32 {~cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0}} | {sram_16bit_512k_0_avalon_slave_0_readdata_from_sa[15 : 0],
    dbs_16_reg_segment_0});

  //actual waitrequest port, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_data_master_waitrequest <= ~0;
      else 
        cpu_data_master_waitrequest <= ~((~(cpu_data_master_read | cpu_data_master_write))? 0: (cpu_data_master_run & cpu_data_master_waitrequest));
    end


  //irq assign, which is an e_assign
  assign cpu_data_master_irq = {1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    1'b0,
    pio_key_s1_irq_from_sa};

  //no_byte_enables_and_last_term, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_data_master_no_byte_enables_and_last_term <= 0;
      else 
        cpu_data_master_no_byte_enables_and_last_term <= last_dbs_term_and_run;
    end


  //compute the last dbs term, which is an e_mux
  assign last_dbs_term_and_run = (cpu_data_master_dbs_address == 2'b10) & cpu_data_master_write & !cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0;

  //pre dbs count enable, which is an e_mux
  assign pre_dbs_count_enable = (((~cpu_data_master_no_byte_enables_and_last_term) & cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0 & cpu_data_master_write & !cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0)) |
    (cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0 & cpu_data_master_read & 1 & 1 & ~d1_sram_16bit_512k_0_avalon_slave_0_end_xfer) |
    ((cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0 & cpu_data_master_write & 1 & 1 & ({sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0 & ~d1_sram_16bit_512k_0_avalon_slave_0_end_xfer})));

  //input to dbs-16 stored 0, which is an e_mux
  assign p1_dbs_16_reg_segment_0 = sram_16bit_512k_0_avalon_slave_0_readdata_from_sa;

  //dbs register for dbs-16 segment 0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          dbs_16_reg_segment_0 <= 0;
      else if (dbs_count_enable & ((cpu_data_master_dbs_address[1]) == 0))
          dbs_16_reg_segment_0 <= p1_dbs_16_reg_segment_0;
    end


  //mux write dbs 1, which is an e_mux
  assign cpu_data_master_dbs_write_16 = (cpu_data_master_dbs_address[1])? cpu_data_master_writedata[31 : 16] :
    cpu_data_master_writedata[15 : 0];

  //dbs count increment, which is an e_mux
  assign cpu_data_master_dbs_increment = (cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0)? 2 :
    0;

  //dbs counter overflow, which is an e_assign
  assign dbs_counter_overflow = cpu_data_master_dbs_address[1] & !(next_dbs_address[1]);

  //next master address, which is an e_assign
  assign next_dbs_address = cpu_data_master_dbs_address + cpu_data_master_dbs_increment;

  //dbs count enable, which is an e_mux
  assign dbs_count_enable = pre_dbs_count_enable;

  //dbs counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_data_master_dbs_address <= 0;
      else if (dbs_count_enable)
          cpu_data_master_dbs_address <= next_dbs_address;
    end



endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module cpu_instruction_master_arbitrator (
                                           // inputs:
                                            clk,
                                            cpu_instruction_master_address,
                                            cpu_instruction_master_granted_cpu_jtag_debug_module,
                                            cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0,
                                            cpu_instruction_master_qualified_request_cpu_jtag_debug_module,
                                            cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0,
                                            cpu_instruction_master_read,
                                            cpu_instruction_master_read_data_valid_cpu_jtag_debug_module,
                                            cpu_instruction_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0,
                                            cpu_instruction_master_requests_cpu_jtag_debug_module,
                                            cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0,
                                            cpu_jtag_debug_module_readdata_from_sa,
                                            d1_cpu_jtag_debug_module_end_xfer,
                                            d1_sram_16bit_512k_0_avalon_slave_0_end_xfer,
                                            reset_n,
                                            sram_16bit_512k_0_avalon_slave_0_readdata_from_sa,
                                            sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0,

                                           // outputs:
                                            cpu_instruction_master_address_to_slave,
                                            cpu_instruction_master_dbs_address,
                                            cpu_instruction_master_latency_counter,
                                            cpu_instruction_master_readdata,
                                            cpu_instruction_master_readdatavalid,
                                            cpu_instruction_master_waitrequest
                                         )
;

  output  [ 20: 0] cpu_instruction_master_address_to_slave;
  output  [  1: 0] cpu_instruction_master_dbs_address;
  output           cpu_instruction_master_latency_counter;
  output  [ 31: 0] cpu_instruction_master_readdata;
  output           cpu_instruction_master_readdatavalid;
  output           cpu_instruction_master_waitrequest;
  input            clk;
  input   [ 20: 0] cpu_instruction_master_address;
  input            cpu_instruction_master_granted_cpu_jtag_debug_module;
  input            cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0;
  input            cpu_instruction_master_qualified_request_cpu_jtag_debug_module;
  input            cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0;
  input            cpu_instruction_master_read;
  input            cpu_instruction_master_read_data_valid_cpu_jtag_debug_module;
  input            cpu_instruction_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0;
  input            cpu_instruction_master_requests_cpu_jtag_debug_module;
  input            cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0;
  input   [ 31: 0] cpu_jtag_debug_module_readdata_from_sa;
  input            d1_cpu_jtag_debug_module_end_xfer;
  input            d1_sram_16bit_512k_0_avalon_slave_0_end_xfer;
  input            reset_n;
  input   [ 15: 0] sram_16bit_512k_0_avalon_slave_0_readdata_from_sa;
  input            sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0;

  reg              active_and_waiting_last_time;
  reg     [ 20: 0] cpu_instruction_master_address_last_time;
  wire    [ 20: 0] cpu_instruction_master_address_to_slave;
  reg     [  1: 0] cpu_instruction_master_dbs_address;
  wire    [  1: 0] cpu_instruction_master_dbs_increment;
  wire             cpu_instruction_master_is_granted_some_slave;
  reg              cpu_instruction_master_latency_counter;
  reg              cpu_instruction_master_read_but_no_slave_selected;
  reg              cpu_instruction_master_read_last_time;
  wire    [ 31: 0] cpu_instruction_master_readdata;
  wire             cpu_instruction_master_readdatavalid;
  wire             cpu_instruction_master_run;
  wire             cpu_instruction_master_waitrequest;
  reg     [ 15: 0] dbs_16_reg_segment_0;
  wire             dbs_count_enable;
  wire             dbs_counter_overflow;
  wire             latency_load_value;
  wire    [  1: 0] next_dbs_address;
  wire             p1_cpu_instruction_master_latency_counter;
  wire    [ 15: 0] p1_dbs_16_reg_segment_0;
  wire             pre_dbs_count_enable;
  wire             pre_flush_cpu_instruction_master_readdatavalid;
  wire             r_0;
  wire             r_1;
  //r_0 master_run cascaded wait assignment, which is an e_assign
  assign r_0 = 1 & (cpu_instruction_master_qualified_request_cpu_jtag_debug_module | ~cpu_instruction_master_requests_cpu_jtag_debug_module) & (cpu_instruction_master_granted_cpu_jtag_debug_module | ~cpu_instruction_master_qualified_request_cpu_jtag_debug_module) & ((~cpu_instruction_master_qualified_request_cpu_jtag_debug_module | ~cpu_instruction_master_read | (1 & ~d1_cpu_jtag_debug_module_end_xfer & cpu_instruction_master_read)));

  //cascaded wait assignment, which is an e_assign
  assign cpu_instruction_master_run = r_0 & r_1;

  //r_1 master_run cascaded wait assignment, which is an e_assign
  assign r_1 = 1 & (cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0 | ~cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0) & (cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0 | ~cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0) & ((~cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0 | ~cpu_instruction_master_read | (1 & ~d1_sram_16bit_512k_0_avalon_slave_0_end_xfer & (cpu_instruction_master_dbs_address[1]) & cpu_instruction_master_read)));

  //optimize select-logic by passing only those address bits which matter.
  assign cpu_instruction_master_address_to_slave = cpu_instruction_master_address[20 : 0];

  //cpu_instruction_master_read_but_no_slave_selected assignment, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_instruction_master_read_but_no_slave_selected <= 0;
      else 
        cpu_instruction_master_read_but_no_slave_selected <= cpu_instruction_master_read & cpu_instruction_master_run & ~cpu_instruction_master_is_granted_some_slave;
    end


  //some slave is getting selected, which is an e_mux
  assign cpu_instruction_master_is_granted_some_slave = cpu_instruction_master_granted_cpu_jtag_debug_module |
    cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0;

  //latent slave read data valids which may be flushed, which is an e_mux
  assign pre_flush_cpu_instruction_master_readdatavalid = 0;

  //latent slave read data valid which is not flushed, which is an e_mux
  assign cpu_instruction_master_readdatavalid = cpu_instruction_master_read_but_no_slave_selected |
    pre_flush_cpu_instruction_master_readdatavalid |
    cpu_instruction_master_read_data_valid_cpu_jtag_debug_module |
    cpu_instruction_master_read_but_no_slave_selected |
    pre_flush_cpu_instruction_master_readdatavalid |
    (cpu_instruction_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0 & dbs_counter_overflow);

  //cpu/instruction_master readdata mux, which is an e_mux
  assign cpu_instruction_master_readdata = ({32 {~(cpu_instruction_master_qualified_request_cpu_jtag_debug_module & cpu_instruction_master_read)}} | cpu_jtag_debug_module_readdata_from_sa) &
    ({32 {~(cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0 & cpu_instruction_master_read)}} | {sram_16bit_512k_0_avalon_slave_0_readdata_from_sa[15 : 0],
    dbs_16_reg_segment_0});

  //actual waitrequest port, which is an e_assign
  assign cpu_instruction_master_waitrequest = ~cpu_instruction_master_run;

  //latent max counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_instruction_master_latency_counter <= 0;
      else 
        cpu_instruction_master_latency_counter <= p1_cpu_instruction_master_latency_counter;
    end


  //latency counter load mux, which is an e_mux
  assign p1_cpu_instruction_master_latency_counter = ((cpu_instruction_master_run & cpu_instruction_master_read))? latency_load_value :
    (cpu_instruction_master_latency_counter)? cpu_instruction_master_latency_counter - 1 :
    0;

  //read latency load values, which is an e_mux
  assign latency_load_value = 0;

  //input to dbs-16 stored 0, which is an e_mux
  assign p1_dbs_16_reg_segment_0 = sram_16bit_512k_0_avalon_slave_0_readdata_from_sa;

  //dbs register for dbs-16 segment 0, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          dbs_16_reg_segment_0 <= 0;
      else if (dbs_count_enable & ((cpu_instruction_master_dbs_address[1]) == 0))
          dbs_16_reg_segment_0 <= p1_dbs_16_reg_segment_0;
    end


  //dbs count increment, which is an e_mux
  assign cpu_instruction_master_dbs_increment = (cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0)? 2 :
    0;

  //dbs counter overflow, which is an e_assign
  assign dbs_counter_overflow = cpu_instruction_master_dbs_address[1] & !(next_dbs_address[1]);

  //next master address, which is an e_assign
  assign next_dbs_address = cpu_instruction_master_dbs_address + cpu_instruction_master_dbs_increment;

  //dbs count enable, which is an e_mux
  assign dbs_count_enable = pre_dbs_count_enable;

  //dbs counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_instruction_master_dbs_address <= 0;
      else if (dbs_count_enable)
          cpu_instruction_master_dbs_address <= next_dbs_address;
    end


  //pre dbs count enable, which is an e_mux
  assign pre_dbs_count_enable = cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0 & cpu_instruction_master_read & 1 & 1 & ~d1_sram_16bit_512k_0_avalon_slave_0_end_xfer;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //cpu_instruction_master_address check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_instruction_master_address_last_time <= 0;
      else 
        cpu_instruction_master_address_last_time <= cpu_instruction_master_address;
    end


  //cpu/instruction_master waited last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          active_and_waiting_last_time <= 0;
      else 
        active_and_waiting_last_time <= cpu_instruction_master_waitrequest & (cpu_instruction_master_read);
    end


  //cpu_instruction_master_address matches last port_name, which is an e_process
  always @(posedge clk)
    begin
      if (active_and_waiting_last_time & (cpu_instruction_master_address != cpu_instruction_master_address_last_time))
        begin
          $write("%0d ns: cpu_instruction_master_address did not heed wait!!!", $time);
          $stop;
        end
    end


  //cpu_instruction_master_read check against wait, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          cpu_instruction_master_read_last_time <= 0;
      else 
        cpu_instruction_master_read_last_time <= cpu_instruction_master_read;
    end


  //cpu_instruction_master_read matches last port_name, which is an e_process
  always @(posedge clk)
    begin
      if (active_and_waiting_last_time & (cpu_instruction_master_read != cpu_instruction_master_read_last_time))
        begin
          $write("%0d ns: cpu_instruction_master_read did not heed wait!!!", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module pio_hex_s1_arbitrator (
                               // inputs:
                                clk,
                                cpu_data_master_address_to_slave,
                                cpu_data_master_read,
                                cpu_data_master_waitrequest,
                                cpu_data_master_write,
                                cpu_data_master_writedata,
                                pio_hex_s1_readdata,
                                reset_n,

                               // outputs:
                                cpu_data_master_granted_pio_hex_s1,
                                cpu_data_master_qualified_request_pio_hex_s1,
                                cpu_data_master_read_data_valid_pio_hex_s1,
                                cpu_data_master_requests_pio_hex_s1,
                                d1_pio_hex_s1_end_xfer,
                                pio_hex_s1_address,
                                pio_hex_s1_chipselect,
                                pio_hex_s1_readdata_from_sa,
                                pio_hex_s1_reset_n,
                                pio_hex_s1_write_n,
                                pio_hex_s1_writedata
                             )
;

  output           cpu_data_master_granted_pio_hex_s1;
  output           cpu_data_master_qualified_request_pio_hex_s1;
  output           cpu_data_master_read_data_valid_pio_hex_s1;
  output           cpu_data_master_requests_pio_hex_s1;
  output           d1_pio_hex_s1_end_xfer;
  output  [  1: 0] pio_hex_s1_address;
  output           pio_hex_s1_chipselect;
  output  [ 31: 0] pio_hex_s1_readdata_from_sa;
  output           pio_hex_s1_reset_n;
  output           pio_hex_s1_write_n;
  output  [ 31: 0] pio_hex_s1_writedata;
  input            clk;
  input   [ 20: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_read;
  input            cpu_data_master_waitrequest;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input   [ 31: 0] pio_hex_s1_readdata;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_pio_hex_s1;
  wire             cpu_data_master_qualified_request_pio_hex_s1;
  wire             cpu_data_master_read_data_valid_pio_hex_s1;
  wire             cpu_data_master_requests_pio_hex_s1;
  wire             cpu_data_master_saved_grant_pio_hex_s1;
  reg              d1_pio_hex_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_pio_hex_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] pio_hex_s1_address;
  wire             pio_hex_s1_allgrants;
  wire             pio_hex_s1_allow_new_arb_cycle;
  wire             pio_hex_s1_any_bursting_master_saved_grant;
  wire             pio_hex_s1_any_continuerequest;
  wire             pio_hex_s1_arb_counter_enable;
  reg     [  1: 0] pio_hex_s1_arb_share_counter;
  wire    [  1: 0] pio_hex_s1_arb_share_counter_next_value;
  wire    [  1: 0] pio_hex_s1_arb_share_set_values;
  wire             pio_hex_s1_beginbursttransfer_internal;
  wire             pio_hex_s1_begins_xfer;
  wire             pio_hex_s1_chipselect;
  wire             pio_hex_s1_end_xfer;
  wire             pio_hex_s1_firsttransfer;
  wire             pio_hex_s1_grant_vector;
  wire             pio_hex_s1_in_a_read_cycle;
  wire             pio_hex_s1_in_a_write_cycle;
  wire             pio_hex_s1_master_qreq_vector;
  wire             pio_hex_s1_non_bursting_master_requests;
  wire    [ 31: 0] pio_hex_s1_readdata_from_sa;
  reg              pio_hex_s1_reg_firsttransfer;
  wire             pio_hex_s1_reset_n;
  reg              pio_hex_s1_slavearbiterlockenable;
  wire             pio_hex_s1_slavearbiterlockenable2;
  wire             pio_hex_s1_unreg_firsttransfer;
  wire             pio_hex_s1_waits_for_read;
  wire             pio_hex_s1_waits_for_write;
  wire             pio_hex_s1_write_n;
  wire    [ 31: 0] pio_hex_s1_writedata;
  wire    [ 20: 0] shifted_address_to_pio_hex_s1_from_cpu_data_master;
  wire             wait_for_pio_hex_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~pio_hex_s1_end_xfer;
    end


  assign pio_hex_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_pio_hex_s1));
  //assign pio_hex_s1_readdata_from_sa = pio_hex_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign pio_hex_s1_readdata_from_sa = pio_hex_s1_readdata;

  assign cpu_data_master_requests_pio_hex_s1 = ({cpu_data_master_address_to_slave[20 : 4] , 4'b0} == 21'h101020) & (cpu_data_master_read | cpu_data_master_write);
  //pio_hex_s1_arb_share_counter set values, which is an e_mux
  assign pio_hex_s1_arb_share_set_values = 1;

  //pio_hex_s1_non_bursting_master_requests mux, which is an e_mux
  assign pio_hex_s1_non_bursting_master_requests = cpu_data_master_requests_pio_hex_s1;

  //pio_hex_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign pio_hex_s1_any_bursting_master_saved_grant = 0;

  //pio_hex_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign pio_hex_s1_arb_share_counter_next_value = pio_hex_s1_firsttransfer ? (pio_hex_s1_arb_share_set_values - 1) : |pio_hex_s1_arb_share_counter ? (pio_hex_s1_arb_share_counter - 1) : 0;

  //pio_hex_s1_allgrants all slave grants, which is an e_mux
  assign pio_hex_s1_allgrants = |pio_hex_s1_grant_vector;

  //pio_hex_s1_end_xfer assignment, which is an e_assign
  assign pio_hex_s1_end_xfer = ~(pio_hex_s1_waits_for_read | pio_hex_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_pio_hex_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_pio_hex_s1 = pio_hex_s1_end_xfer & (~pio_hex_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //pio_hex_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign pio_hex_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_pio_hex_s1 & pio_hex_s1_allgrants) | (end_xfer_arb_share_counter_term_pio_hex_s1 & ~pio_hex_s1_non_bursting_master_requests);

  //pio_hex_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_hex_s1_arb_share_counter <= 0;
      else if (pio_hex_s1_arb_counter_enable)
          pio_hex_s1_arb_share_counter <= pio_hex_s1_arb_share_counter_next_value;
    end


  //pio_hex_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_hex_s1_slavearbiterlockenable <= 0;
      else if ((|pio_hex_s1_master_qreq_vector & end_xfer_arb_share_counter_term_pio_hex_s1) | (end_xfer_arb_share_counter_term_pio_hex_s1 & ~pio_hex_s1_non_bursting_master_requests))
          pio_hex_s1_slavearbiterlockenable <= |pio_hex_s1_arb_share_counter_next_value;
    end


  //cpu/data_master pio_hex/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = pio_hex_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //pio_hex_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign pio_hex_s1_slavearbiterlockenable2 = |pio_hex_s1_arb_share_counter_next_value;

  //cpu/data_master pio_hex/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = pio_hex_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //pio_hex_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign pio_hex_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_pio_hex_s1 = cpu_data_master_requests_pio_hex_s1 & ~(((~cpu_data_master_waitrequest) & cpu_data_master_write));
  //pio_hex_s1_writedata mux, which is an e_mux
  assign pio_hex_s1_writedata = cpu_data_master_writedata;

  //master is always granted when requested
  assign cpu_data_master_granted_pio_hex_s1 = cpu_data_master_qualified_request_pio_hex_s1;

  //cpu/data_master saved-grant pio_hex/s1, which is an e_assign
  assign cpu_data_master_saved_grant_pio_hex_s1 = cpu_data_master_requests_pio_hex_s1;

  //allow new arb cycle for pio_hex/s1, which is an e_assign
  assign pio_hex_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign pio_hex_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign pio_hex_s1_master_qreq_vector = 1;

  //pio_hex_s1_reset_n assignment, which is an e_assign
  assign pio_hex_s1_reset_n = reset_n;

  assign pio_hex_s1_chipselect = cpu_data_master_granted_pio_hex_s1;
  //pio_hex_s1_firsttransfer first transaction, which is an e_assign
  assign pio_hex_s1_firsttransfer = pio_hex_s1_begins_xfer ? pio_hex_s1_unreg_firsttransfer : pio_hex_s1_reg_firsttransfer;

  //pio_hex_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign pio_hex_s1_unreg_firsttransfer = ~(pio_hex_s1_slavearbiterlockenable & pio_hex_s1_any_continuerequest);

  //pio_hex_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_hex_s1_reg_firsttransfer <= 1'b1;
      else if (pio_hex_s1_begins_xfer)
          pio_hex_s1_reg_firsttransfer <= pio_hex_s1_unreg_firsttransfer;
    end


  //pio_hex_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign pio_hex_s1_beginbursttransfer_internal = pio_hex_s1_begins_xfer;

  //~pio_hex_s1_write_n assignment, which is an e_mux
  assign pio_hex_s1_write_n = ~(cpu_data_master_granted_pio_hex_s1 & cpu_data_master_write);

  assign shifted_address_to_pio_hex_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //pio_hex_s1_address mux, which is an e_mux
  assign pio_hex_s1_address = shifted_address_to_pio_hex_s1_from_cpu_data_master >> 2;

  //d1_pio_hex_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_pio_hex_s1_end_xfer <= 1;
      else 
        d1_pio_hex_s1_end_xfer <= pio_hex_s1_end_xfer;
    end


  //pio_hex_s1_waits_for_read in a cycle, which is an e_mux
  assign pio_hex_s1_waits_for_read = pio_hex_s1_in_a_read_cycle & pio_hex_s1_begins_xfer;

  //pio_hex_s1_in_a_read_cycle assignment, which is an e_assign
  assign pio_hex_s1_in_a_read_cycle = cpu_data_master_granted_pio_hex_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = pio_hex_s1_in_a_read_cycle;

  //pio_hex_s1_waits_for_write in a cycle, which is an e_mux
  assign pio_hex_s1_waits_for_write = pio_hex_s1_in_a_write_cycle & 0;

  //pio_hex_s1_in_a_write_cycle assignment, which is an e_assign
  assign pio_hex_s1_in_a_write_cycle = cpu_data_master_granted_pio_hex_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = pio_hex_s1_in_a_write_cycle;

  assign wait_for_pio_hex_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //pio_hex/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module pio_key_s1_arbitrator (
                               // inputs:
                                clk,
                                cpu_data_master_address_to_slave,
                                cpu_data_master_read,
                                cpu_data_master_waitrequest,
                                cpu_data_master_write,
                                cpu_data_master_writedata,
                                pio_key_s1_irq,
                                pio_key_s1_readdata,
                                reset_n,

                               // outputs:
                                cpu_data_master_granted_pio_key_s1,
                                cpu_data_master_qualified_request_pio_key_s1,
                                cpu_data_master_read_data_valid_pio_key_s1,
                                cpu_data_master_requests_pio_key_s1,
                                d1_pio_key_s1_end_xfer,
                                pio_key_s1_address,
                                pio_key_s1_chipselect,
                                pio_key_s1_irq_from_sa,
                                pio_key_s1_readdata_from_sa,
                                pio_key_s1_reset_n,
                                pio_key_s1_write_n,
                                pio_key_s1_writedata
                             )
;

  output           cpu_data_master_granted_pio_key_s1;
  output           cpu_data_master_qualified_request_pio_key_s1;
  output           cpu_data_master_read_data_valid_pio_key_s1;
  output           cpu_data_master_requests_pio_key_s1;
  output           d1_pio_key_s1_end_xfer;
  output  [  1: 0] pio_key_s1_address;
  output           pio_key_s1_chipselect;
  output           pio_key_s1_irq_from_sa;
  output  [ 31: 0] pio_key_s1_readdata_from_sa;
  output           pio_key_s1_reset_n;
  output           pio_key_s1_write_n;
  output  [ 31: 0] pio_key_s1_writedata;
  input            clk;
  input   [ 20: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_read;
  input            cpu_data_master_waitrequest;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input            pio_key_s1_irq;
  input   [ 31: 0] pio_key_s1_readdata;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_pio_key_s1;
  wire             cpu_data_master_qualified_request_pio_key_s1;
  wire             cpu_data_master_read_data_valid_pio_key_s1;
  wire             cpu_data_master_requests_pio_key_s1;
  wire             cpu_data_master_saved_grant_pio_key_s1;
  reg              d1_pio_key_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_pio_key_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] pio_key_s1_address;
  wire             pio_key_s1_allgrants;
  wire             pio_key_s1_allow_new_arb_cycle;
  wire             pio_key_s1_any_bursting_master_saved_grant;
  wire             pio_key_s1_any_continuerequest;
  wire             pio_key_s1_arb_counter_enable;
  reg     [  1: 0] pio_key_s1_arb_share_counter;
  wire    [  1: 0] pio_key_s1_arb_share_counter_next_value;
  wire    [  1: 0] pio_key_s1_arb_share_set_values;
  wire             pio_key_s1_beginbursttransfer_internal;
  wire             pio_key_s1_begins_xfer;
  wire             pio_key_s1_chipselect;
  wire             pio_key_s1_end_xfer;
  wire             pio_key_s1_firsttransfer;
  wire             pio_key_s1_grant_vector;
  wire             pio_key_s1_in_a_read_cycle;
  wire             pio_key_s1_in_a_write_cycle;
  wire             pio_key_s1_irq_from_sa;
  wire             pio_key_s1_master_qreq_vector;
  wire             pio_key_s1_non_bursting_master_requests;
  wire    [ 31: 0] pio_key_s1_readdata_from_sa;
  reg              pio_key_s1_reg_firsttransfer;
  wire             pio_key_s1_reset_n;
  reg              pio_key_s1_slavearbiterlockenable;
  wire             pio_key_s1_slavearbiterlockenable2;
  wire             pio_key_s1_unreg_firsttransfer;
  wire             pio_key_s1_waits_for_read;
  wire             pio_key_s1_waits_for_write;
  wire             pio_key_s1_write_n;
  wire    [ 31: 0] pio_key_s1_writedata;
  wire    [ 20: 0] shifted_address_to_pio_key_s1_from_cpu_data_master;
  wire             wait_for_pio_key_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~pio_key_s1_end_xfer;
    end


  assign pio_key_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_pio_key_s1));
  //assign pio_key_s1_readdata_from_sa = pio_key_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign pio_key_s1_readdata_from_sa = pio_key_s1_readdata;

  assign cpu_data_master_requests_pio_key_s1 = ({cpu_data_master_address_to_slave[20 : 4] , 4'b0} == 21'h101000) & (cpu_data_master_read | cpu_data_master_write);
  //pio_key_s1_arb_share_counter set values, which is an e_mux
  assign pio_key_s1_arb_share_set_values = 1;

  //pio_key_s1_non_bursting_master_requests mux, which is an e_mux
  assign pio_key_s1_non_bursting_master_requests = cpu_data_master_requests_pio_key_s1;

  //pio_key_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign pio_key_s1_any_bursting_master_saved_grant = 0;

  //pio_key_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign pio_key_s1_arb_share_counter_next_value = pio_key_s1_firsttransfer ? (pio_key_s1_arb_share_set_values - 1) : |pio_key_s1_arb_share_counter ? (pio_key_s1_arb_share_counter - 1) : 0;

  //pio_key_s1_allgrants all slave grants, which is an e_mux
  assign pio_key_s1_allgrants = |pio_key_s1_grant_vector;

  //pio_key_s1_end_xfer assignment, which is an e_assign
  assign pio_key_s1_end_xfer = ~(pio_key_s1_waits_for_read | pio_key_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_pio_key_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_pio_key_s1 = pio_key_s1_end_xfer & (~pio_key_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //pio_key_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign pio_key_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_pio_key_s1 & pio_key_s1_allgrants) | (end_xfer_arb_share_counter_term_pio_key_s1 & ~pio_key_s1_non_bursting_master_requests);

  //pio_key_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_key_s1_arb_share_counter <= 0;
      else if (pio_key_s1_arb_counter_enable)
          pio_key_s1_arb_share_counter <= pio_key_s1_arb_share_counter_next_value;
    end


  //pio_key_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_key_s1_slavearbiterlockenable <= 0;
      else if ((|pio_key_s1_master_qreq_vector & end_xfer_arb_share_counter_term_pio_key_s1) | (end_xfer_arb_share_counter_term_pio_key_s1 & ~pio_key_s1_non_bursting_master_requests))
          pio_key_s1_slavearbiterlockenable <= |pio_key_s1_arb_share_counter_next_value;
    end


  //cpu/data_master pio_key/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = pio_key_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //pio_key_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign pio_key_s1_slavearbiterlockenable2 = |pio_key_s1_arb_share_counter_next_value;

  //cpu/data_master pio_key/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = pio_key_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //pio_key_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign pio_key_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_pio_key_s1 = cpu_data_master_requests_pio_key_s1 & ~(((~cpu_data_master_waitrequest) & cpu_data_master_write));
  //pio_key_s1_writedata mux, which is an e_mux
  assign pio_key_s1_writedata = cpu_data_master_writedata;

  //master is always granted when requested
  assign cpu_data_master_granted_pio_key_s1 = cpu_data_master_qualified_request_pio_key_s1;

  //cpu/data_master saved-grant pio_key/s1, which is an e_assign
  assign cpu_data_master_saved_grant_pio_key_s1 = cpu_data_master_requests_pio_key_s1;

  //allow new arb cycle for pio_key/s1, which is an e_assign
  assign pio_key_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign pio_key_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign pio_key_s1_master_qreq_vector = 1;

  //pio_key_s1_reset_n assignment, which is an e_assign
  assign pio_key_s1_reset_n = reset_n;

  assign pio_key_s1_chipselect = cpu_data_master_granted_pio_key_s1;
  //pio_key_s1_firsttransfer first transaction, which is an e_assign
  assign pio_key_s1_firsttransfer = pio_key_s1_begins_xfer ? pio_key_s1_unreg_firsttransfer : pio_key_s1_reg_firsttransfer;

  //pio_key_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign pio_key_s1_unreg_firsttransfer = ~(pio_key_s1_slavearbiterlockenable & pio_key_s1_any_continuerequest);

  //pio_key_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_key_s1_reg_firsttransfer <= 1'b1;
      else if (pio_key_s1_begins_xfer)
          pio_key_s1_reg_firsttransfer <= pio_key_s1_unreg_firsttransfer;
    end


  //pio_key_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign pio_key_s1_beginbursttransfer_internal = pio_key_s1_begins_xfer;

  //~pio_key_s1_write_n assignment, which is an e_mux
  assign pio_key_s1_write_n = ~(cpu_data_master_granted_pio_key_s1 & cpu_data_master_write);

  assign shifted_address_to_pio_key_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //pio_key_s1_address mux, which is an e_mux
  assign pio_key_s1_address = shifted_address_to_pio_key_s1_from_cpu_data_master >> 2;

  //d1_pio_key_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_pio_key_s1_end_xfer <= 1;
      else 
        d1_pio_key_s1_end_xfer <= pio_key_s1_end_xfer;
    end


  //pio_key_s1_waits_for_read in a cycle, which is an e_mux
  assign pio_key_s1_waits_for_read = pio_key_s1_in_a_read_cycle & pio_key_s1_begins_xfer;

  //pio_key_s1_in_a_read_cycle assignment, which is an e_assign
  assign pio_key_s1_in_a_read_cycle = cpu_data_master_granted_pio_key_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = pio_key_s1_in_a_read_cycle;

  //pio_key_s1_waits_for_write in a cycle, which is an e_mux
  assign pio_key_s1_waits_for_write = pio_key_s1_in_a_write_cycle & 0;

  //pio_key_s1_in_a_write_cycle assignment, which is an e_assign
  assign pio_key_s1_in_a_write_cycle = cpu_data_master_granted_pio_key_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = pio_key_s1_in_a_write_cycle;

  assign wait_for_pio_key_s1_counter = 0;
  //assign pio_key_s1_irq_from_sa = pio_key_s1_irq so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign pio_key_s1_irq_from_sa = pio_key_s1_irq;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //pio_key/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module pio_left_s1_arbitrator (
                                // inputs:
                                 clk,
                                 cpu_data_master_address_to_slave,
                                 cpu_data_master_read,
                                 cpu_data_master_waitrequest,
                                 cpu_data_master_write,
                                 cpu_data_master_writedata,
                                 pio_left_s1_readdata,
                                 reset_n,

                                // outputs:
                                 cpu_data_master_granted_pio_left_s1,
                                 cpu_data_master_qualified_request_pio_left_s1,
                                 cpu_data_master_read_data_valid_pio_left_s1,
                                 cpu_data_master_requests_pio_left_s1,
                                 d1_pio_left_s1_end_xfer,
                                 pio_left_s1_address,
                                 pio_left_s1_chipselect,
                                 pio_left_s1_readdata_from_sa,
                                 pio_left_s1_reset_n,
                                 pio_left_s1_write_n,
                                 pio_left_s1_writedata
                              )
;

  output           cpu_data_master_granted_pio_left_s1;
  output           cpu_data_master_qualified_request_pio_left_s1;
  output           cpu_data_master_read_data_valid_pio_left_s1;
  output           cpu_data_master_requests_pio_left_s1;
  output           d1_pio_left_s1_end_xfer;
  output  [  1: 0] pio_left_s1_address;
  output           pio_left_s1_chipselect;
  output  [ 31: 0] pio_left_s1_readdata_from_sa;
  output           pio_left_s1_reset_n;
  output           pio_left_s1_write_n;
  output  [ 31: 0] pio_left_s1_writedata;
  input            clk;
  input   [ 20: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_read;
  input            cpu_data_master_waitrequest;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input   [ 31: 0] pio_left_s1_readdata;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_pio_left_s1;
  wire             cpu_data_master_qualified_request_pio_left_s1;
  wire             cpu_data_master_read_data_valid_pio_left_s1;
  wire             cpu_data_master_requests_pio_left_s1;
  wire             cpu_data_master_saved_grant_pio_left_s1;
  reg              d1_pio_left_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_pio_left_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] pio_left_s1_address;
  wire             pio_left_s1_allgrants;
  wire             pio_left_s1_allow_new_arb_cycle;
  wire             pio_left_s1_any_bursting_master_saved_grant;
  wire             pio_left_s1_any_continuerequest;
  wire             pio_left_s1_arb_counter_enable;
  reg     [  1: 0] pio_left_s1_arb_share_counter;
  wire    [  1: 0] pio_left_s1_arb_share_counter_next_value;
  wire    [  1: 0] pio_left_s1_arb_share_set_values;
  wire             pio_left_s1_beginbursttransfer_internal;
  wire             pio_left_s1_begins_xfer;
  wire             pio_left_s1_chipselect;
  wire             pio_left_s1_end_xfer;
  wire             pio_left_s1_firsttransfer;
  wire             pio_left_s1_grant_vector;
  wire             pio_left_s1_in_a_read_cycle;
  wire             pio_left_s1_in_a_write_cycle;
  wire             pio_left_s1_master_qreq_vector;
  wire             pio_left_s1_non_bursting_master_requests;
  wire    [ 31: 0] pio_left_s1_readdata_from_sa;
  reg              pio_left_s1_reg_firsttransfer;
  wire             pio_left_s1_reset_n;
  reg              pio_left_s1_slavearbiterlockenable;
  wire             pio_left_s1_slavearbiterlockenable2;
  wire             pio_left_s1_unreg_firsttransfer;
  wire             pio_left_s1_waits_for_read;
  wire             pio_left_s1_waits_for_write;
  wire             pio_left_s1_write_n;
  wire    [ 31: 0] pio_left_s1_writedata;
  wire    [ 20: 0] shifted_address_to_pio_left_s1_from_cpu_data_master;
  wire             wait_for_pio_left_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~pio_left_s1_end_xfer;
    end


  assign pio_left_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_pio_left_s1));
  //assign pio_left_s1_readdata_from_sa = pio_left_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign pio_left_s1_readdata_from_sa = pio_left_s1_readdata;

  assign cpu_data_master_requests_pio_left_s1 = ({cpu_data_master_address_to_slave[20 : 4] , 4'b0} == 21'h101040) & (cpu_data_master_read | cpu_data_master_write);
  //pio_left_s1_arb_share_counter set values, which is an e_mux
  assign pio_left_s1_arb_share_set_values = 1;

  //pio_left_s1_non_bursting_master_requests mux, which is an e_mux
  assign pio_left_s1_non_bursting_master_requests = cpu_data_master_requests_pio_left_s1;

  //pio_left_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign pio_left_s1_any_bursting_master_saved_grant = 0;

  //pio_left_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign pio_left_s1_arb_share_counter_next_value = pio_left_s1_firsttransfer ? (pio_left_s1_arb_share_set_values - 1) : |pio_left_s1_arb_share_counter ? (pio_left_s1_arb_share_counter - 1) : 0;

  //pio_left_s1_allgrants all slave grants, which is an e_mux
  assign pio_left_s1_allgrants = |pio_left_s1_grant_vector;

  //pio_left_s1_end_xfer assignment, which is an e_assign
  assign pio_left_s1_end_xfer = ~(pio_left_s1_waits_for_read | pio_left_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_pio_left_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_pio_left_s1 = pio_left_s1_end_xfer & (~pio_left_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //pio_left_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign pio_left_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_pio_left_s1 & pio_left_s1_allgrants) | (end_xfer_arb_share_counter_term_pio_left_s1 & ~pio_left_s1_non_bursting_master_requests);

  //pio_left_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_left_s1_arb_share_counter <= 0;
      else if (pio_left_s1_arb_counter_enable)
          pio_left_s1_arb_share_counter <= pio_left_s1_arb_share_counter_next_value;
    end


  //pio_left_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_left_s1_slavearbiterlockenable <= 0;
      else if ((|pio_left_s1_master_qreq_vector & end_xfer_arb_share_counter_term_pio_left_s1) | (end_xfer_arb_share_counter_term_pio_left_s1 & ~pio_left_s1_non_bursting_master_requests))
          pio_left_s1_slavearbiterlockenable <= |pio_left_s1_arb_share_counter_next_value;
    end


  //cpu/data_master pio_left/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = pio_left_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //pio_left_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign pio_left_s1_slavearbiterlockenable2 = |pio_left_s1_arb_share_counter_next_value;

  //cpu/data_master pio_left/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = pio_left_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //pio_left_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign pio_left_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_pio_left_s1 = cpu_data_master_requests_pio_left_s1 & ~(((~cpu_data_master_waitrequest) & cpu_data_master_write));
  //pio_left_s1_writedata mux, which is an e_mux
  assign pio_left_s1_writedata = cpu_data_master_writedata;

  //master is always granted when requested
  assign cpu_data_master_granted_pio_left_s1 = cpu_data_master_qualified_request_pio_left_s1;

  //cpu/data_master saved-grant pio_left/s1, which is an e_assign
  assign cpu_data_master_saved_grant_pio_left_s1 = cpu_data_master_requests_pio_left_s1;

  //allow new arb cycle for pio_left/s1, which is an e_assign
  assign pio_left_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign pio_left_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign pio_left_s1_master_qreq_vector = 1;

  //pio_left_s1_reset_n assignment, which is an e_assign
  assign pio_left_s1_reset_n = reset_n;

  assign pio_left_s1_chipselect = cpu_data_master_granted_pio_left_s1;
  //pio_left_s1_firsttransfer first transaction, which is an e_assign
  assign pio_left_s1_firsttransfer = pio_left_s1_begins_xfer ? pio_left_s1_unreg_firsttransfer : pio_left_s1_reg_firsttransfer;

  //pio_left_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign pio_left_s1_unreg_firsttransfer = ~(pio_left_s1_slavearbiterlockenable & pio_left_s1_any_continuerequest);

  //pio_left_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_left_s1_reg_firsttransfer <= 1'b1;
      else if (pio_left_s1_begins_xfer)
          pio_left_s1_reg_firsttransfer <= pio_left_s1_unreg_firsttransfer;
    end


  //pio_left_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign pio_left_s1_beginbursttransfer_internal = pio_left_s1_begins_xfer;

  //~pio_left_s1_write_n assignment, which is an e_mux
  assign pio_left_s1_write_n = ~(cpu_data_master_granted_pio_left_s1 & cpu_data_master_write);

  assign shifted_address_to_pio_left_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //pio_left_s1_address mux, which is an e_mux
  assign pio_left_s1_address = shifted_address_to_pio_left_s1_from_cpu_data_master >> 2;

  //d1_pio_left_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_pio_left_s1_end_xfer <= 1;
      else 
        d1_pio_left_s1_end_xfer <= pio_left_s1_end_xfer;
    end


  //pio_left_s1_waits_for_read in a cycle, which is an e_mux
  assign pio_left_s1_waits_for_read = pio_left_s1_in_a_read_cycle & pio_left_s1_begins_xfer;

  //pio_left_s1_in_a_read_cycle assignment, which is an e_assign
  assign pio_left_s1_in_a_read_cycle = cpu_data_master_granted_pio_left_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = pio_left_s1_in_a_read_cycle;

  //pio_left_s1_waits_for_write in a cycle, which is an e_mux
  assign pio_left_s1_waits_for_write = pio_left_s1_in_a_write_cycle & 0;

  //pio_left_s1_in_a_write_cycle assignment, which is an e_assign
  assign pio_left_s1_in_a_write_cycle = cpu_data_master_granted_pio_left_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = pio_left_s1_in_a_write_cycle;

  assign wait_for_pio_left_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //pio_left/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module pio_pingpong_s1_arbitrator (
                                    // inputs:
                                     clk,
                                     cpu_data_master_address_to_slave,
                                     cpu_data_master_read,
                                     cpu_data_master_waitrequest,
                                     cpu_data_master_write,
                                     cpu_data_master_writedata,
                                     pio_pingpong_s1_readdata,
                                     reset_n,

                                    // outputs:
                                     cpu_data_master_granted_pio_pingpong_s1,
                                     cpu_data_master_qualified_request_pio_pingpong_s1,
                                     cpu_data_master_read_data_valid_pio_pingpong_s1,
                                     cpu_data_master_requests_pio_pingpong_s1,
                                     d1_pio_pingpong_s1_end_xfer,
                                     pio_pingpong_s1_address,
                                     pio_pingpong_s1_chipselect,
                                     pio_pingpong_s1_readdata_from_sa,
                                     pio_pingpong_s1_reset_n,
                                     pio_pingpong_s1_write_n,
                                     pio_pingpong_s1_writedata
                                  )
;

  output           cpu_data_master_granted_pio_pingpong_s1;
  output           cpu_data_master_qualified_request_pio_pingpong_s1;
  output           cpu_data_master_read_data_valid_pio_pingpong_s1;
  output           cpu_data_master_requests_pio_pingpong_s1;
  output           d1_pio_pingpong_s1_end_xfer;
  output  [  1: 0] pio_pingpong_s1_address;
  output           pio_pingpong_s1_chipselect;
  output  [ 31: 0] pio_pingpong_s1_readdata_from_sa;
  output           pio_pingpong_s1_reset_n;
  output           pio_pingpong_s1_write_n;
  output  [ 31: 0] pio_pingpong_s1_writedata;
  input            clk;
  input   [ 20: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_read;
  input            cpu_data_master_waitrequest;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input   [ 31: 0] pio_pingpong_s1_readdata;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_pio_pingpong_s1;
  wire             cpu_data_master_qualified_request_pio_pingpong_s1;
  wire             cpu_data_master_read_data_valid_pio_pingpong_s1;
  wire             cpu_data_master_requests_pio_pingpong_s1;
  wire             cpu_data_master_saved_grant_pio_pingpong_s1;
  reg              d1_pio_pingpong_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_pio_pingpong_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] pio_pingpong_s1_address;
  wire             pio_pingpong_s1_allgrants;
  wire             pio_pingpong_s1_allow_new_arb_cycle;
  wire             pio_pingpong_s1_any_bursting_master_saved_grant;
  wire             pio_pingpong_s1_any_continuerequest;
  wire             pio_pingpong_s1_arb_counter_enable;
  reg     [  1: 0] pio_pingpong_s1_arb_share_counter;
  wire    [  1: 0] pio_pingpong_s1_arb_share_counter_next_value;
  wire    [  1: 0] pio_pingpong_s1_arb_share_set_values;
  wire             pio_pingpong_s1_beginbursttransfer_internal;
  wire             pio_pingpong_s1_begins_xfer;
  wire             pio_pingpong_s1_chipselect;
  wire             pio_pingpong_s1_end_xfer;
  wire             pio_pingpong_s1_firsttransfer;
  wire             pio_pingpong_s1_grant_vector;
  wire             pio_pingpong_s1_in_a_read_cycle;
  wire             pio_pingpong_s1_in_a_write_cycle;
  wire             pio_pingpong_s1_master_qreq_vector;
  wire             pio_pingpong_s1_non_bursting_master_requests;
  wire    [ 31: 0] pio_pingpong_s1_readdata_from_sa;
  reg              pio_pingpong_s1_reg_firsttransfer;
  wire             pio_pingpong_s1_reset_n;
  reg              pio_pingpong_s1_slavearbiterlockenable;
  wire             pio_pingpong_s1_slavearbiterlockenable2;
  wire             pio_pingpong_s1_unreg_firsttransfer;
  wire             pio_pingpong_s1_waits_for_read;
  wire             pio_pingpong_s1_waits_for_write;
  wire             pio_pingpong_s1_write_n;
  wire    [ 31: 0] pio_pingpong_s1_writedata;
  wire    [ 20: 0] shifted_address_to_pio_pingpong_s1_from_cpu_data_master;
  wire             wait_for_pio_pingpong_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~pio_pingpong_s1_end_xfer;
    end


  assign pio_pingpong_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_pio_pingpong_s1));
  //assign pio_pingpong_s1_readdata_from_sa = pio_pingpong_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign pio_pingpong_s1_readdata_from_sa = pio_pingpong_s1_readdata;

  assign cpu_data_master_requests_pio_pingpong_s1 = ({cpu_data_master_address_to_slave[20 : 4] , 4'b0} == 21'h101030) & (cpu_data_master_read | cpu_data_master_write);
  //pio_pingpong_s1_arb_share_counter set values, which is an e_mux
  assign pio_pingpong_s1_arb_share_set_values = 1;

  //pio_pingpong_s1_non_bursting_master_requests mux, which is an e_mux
  assign pio_pingpong_s1_non_bursting_master_requests = cpu_data_master_requests_pio_pingpong_s1;

  //pio_pingpong_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign pio_pingpong_s1_any_bursting_master_saved_grant = 0;

  //pio_pingpong_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign pio_pingpong_s1_arb_share_counter_next_value = pio_pingpong_s1_firsttransfer ? (pio_pingpong_s1_arb_share_set_values - 1) : |pio_pingpong_s1_arb_share_counter ? (pio_pingpong_s1_arb_share_counter - 1) : 0;

  //pio_pingpong_s1_allgrants all slave grants, which is an e_mux
  assign pio_pingpong_s1_allgrants = |pio_pingpong_s1_grant_vector;

  //pio_pingpong_s1_end_xfer assignment, which is an e_assign
  assign pio_pingpong_s1_end_xfer = ~(pio_pingpong_s1_waits_for_read | pio_pingpong_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_pio_pingpong_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_pio_pingpong_s1 = pio_pingpong_s1_end_xfer & (~pio_pingpong_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //pio_pingpong_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign pio_pingpong_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_pio_pingpong_s1 & pio_pingpong_s1_allgrants) | (end_xfer_arb_share_counter_term_pio_pingpong_s1 & ~pio_pingpong_s1_non_bursting_master_requests);

  //pio_pingpong_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_pingpong_s1_arb_share_counter <= 0;
      else if (pio_pingpong_s1_arb_counter_enable)
          pio_pingpong_s1_arb_share_counter <= pio_pingpong_s1_arb_share_counter_next_value;
    end


  //pio_pingpong_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_pingpong_s1_slavearbiterlockenable <= 0;
      else if ((|pio_pingpong_s1_master_qreq_vector & end_xfer_arb_share_counter_term_pio_pingpong_s1) | (end_xfer_arb_share_counter_term_pio_pingpong_s1 & ~pio_pingpong_s1_non_bursting_master_requests))
          pio_pingpong_s1_slavearbiterlockenable <= |pio_pingpong_s1_arb_share_counter_next_value;
    end


  //cpu/data_master pio_pingpong/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = pio_pingpong_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //pio_pingpong_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign pio_pingpong_s1_slavearbiterlockenable2 = |pio_pingpong_s1_arb_share_counter_next_value;

  //cpu/data_master pio_pingpong/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = pio_pingpong_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //pio_pingpong_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign pio_pingpong_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_pio_pingpong_s1 = cpu_data_master_requests_pio_pingpong_s1 & ~(((~cpu_data_master_waitrequest) & cpu_data_master_write));
  //pio_pingpong_s1_writedata mux, which is an e_mux
  assign pio_pingpong_s1_writedata = cpu_data_master_writedata;

  //master is always granted when requested
  assign cpu_data_master_granted_pio_pingpong_s1 = cpu_data_master_qualified_request_pio_pingpong_s1;

  //cpu/data_master saved-grant pio_pingpong/s1, which is an e_assign
  assign cpu_data_master_saved_grant_pio_pingpong_s1 = cpu_data_master_requests_pio_pingpong_s1;

  //allow new arb cycle for pio_pingpong/s1, which is an e_assign
  assign pio_pingpong_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign pio_pingpong_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign pio_pingpong_s1_master_qreq_vector = 1;

  //pio_pingpong_s1_reset_n assignment, which is an e_assign
  assign pio_pingpong_s1_reset_n = reset_n;

  assign pio_pingpong_s1_chipselect = cpu_data_master_granted_pio_pingpong_s1;
  //pio_pingpong_s1_firsttransfer first transaction, which is an e_assign
  assign pio_pingpong_s1_firsttransfer = pio_pingpong_s1_begins_xfer ? pio_pingpong_s1_unreg_firsttransfer : pio_pingpong_s1_reg_firsttransfer;

  //pio_pingpong_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign pio_pingpong_s1_unreg_firsttransfer = ~(pio_pingpong_s1_slavearbiterlockenable & pio_pingpong_s1_any_continuerequest);

  //pio_pingpong_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_pingpong_s1_reg_firsttransfer <= 1'b1;
      else if (pio_pingpong_s1_begins_xfer)
          pio_pingpong_s1_reg_firsttransfer <= pio_pingpong_s1_unreg_firsttransfer;
    end


  //pio_pingpong_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign pio_pingpong_s1_beginbursttransfer_internal = pio_pingpong_s1_begins_xfer;

  //~pio_pingpong_s1_write_n assignment, which is an e_mux
  assign pio_pingpong_s1_write_n = ~(cpu_data_master_granted_pio_pingpong_s1 & cpu_data_master_write);

  assign shifted_address_to_pio_pingpong_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //pio_pingpong_s1_address mux, which is an e_mux
  assign pio_pingpong_s1_address = shifted_address_to_pio_pingpong_s1_from_cpu_data_master >> 2;

  //d1_pio_pingpong_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_pio_pingpong_s1_end_xfer <= 1;
      else 
        d1_pio_pingpong_s1_end_xfer <= pio_pingpong_s1_end_xfer;
    end


  //pio_pingpong_s1_waits_for_read in a cycle, which is an e_mux
  assign pio_pingpong_s1_waits_for_read = pio_pingpong_s1_in_a_read_cycle & pio_pingpong_s1_begins_xfer;

  //pio_pingpong_s1_in_a_read_cycle assignment, which is an e_assign
  assign pio_pingpong_s1_in_a_read_cycle = cpu_data_master_granted_pio_pingpong_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = pio_pingpong_s1_in_a_read_cycle;

  //pio_pingpong_s1_waits_for_write in a cycle, which is an e_mux
  assign pio_pingpong_s1_waits_for_write = pio_pingpong_s1_in_a_write_cycle & 0;

  //pio_pingpong_s1_in_a_write_cycle assignment, which is an e_assign
  assign pio_pingpong_s1_in_a_write_cycle = cpu_data_master_granted_pio_pingpong_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = pio_pingpong_s1_in_a_write_cycle;

  assign wait_for_pio_pingpong_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //pio_pingpong/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module pio_right_s1_arbitrator (
                                 // inputs:
                                  clk,
                                  cpu_data_master_address_to_slave,
                                  cpu_data_master_read,
                                  cpu_data_master_waitrequest,
                                  cpu_data_master_write,
                                  cpu_data_master_writedata,
                                  pio_right_s1_readdata,
                                  reset_n,

                                 // outputs:
                                  cpu_data_master_granted_pio_right_s1,
                                  cpu_data_master_qualified_request_pio_right_s1,
                                  cpu_data_master_read_data_valid_pio_right_s1,
                                  cpu_data_master_requests_pio_right_s1,
                                  d1_pio_right_s1_end_xfer,
                                  pio_right_s1_address,
                                  pio_right_s1_chipselect,
                                  pio_right_s1_readdata_from_sa,
                                  pio_right_s1_reset_n,
                                  pio_right_s1_write_n,
                                  pio_right_s1_writedata
                               )
;

  output           cpu_data_master_granted_pio_right_s1;
  output           cpu_data_master_qualified_request_pio_right_s1;
  output           cpu_data_master_read_data_valid_pio_right_s1;
  output           cpu_data_master_requests_pio_right_s1;
  output           d1_pio_right_s1_end_xfer;
  output  [  1: 0] pio_right_s1_address;
  output           pio_right_s1_chipselect;
  output  [ 31: 0] pio_right_s1_readdata_from_sa;
  output           pio_right_s1_reset_n;
  output           pio_right_s1_write_n;
  output  [ 31: 0] pio_right_s1_writedata;
  input            clk;
  input   [ 20: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_read;
  input            cpu_data_master_waitrequest;
  input            cpu_data_master_write;
  input   [ 31: 0] cpu_data_master_writedata;
  input   [ 31: 0] pio_right_s1_readdata;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_pio_right_s1;
  wire             cpu_data_master_qualified_request_pio_right_s1;
  wire             cpu_data_master_read_data_valid_pio_right_s1;
  wire             cpu_data_master_requests_pio_right_s1;
  wire             cpu_data_master_saved_grant_pio_right_s1;
  reg              d1_pio_right_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_pio_right_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] pio_right_s1_address;
  wire             pio_right_s1_allgrants;
  wire             pio_right_s1_allow_new_arb_cycle;
  wire             pio_right_s1_any_bursting_master_saved_grant;
  wire             pio_right_s1_any_continuerequest;
  wire             pio_right_s1_arb_counter_enable;
  reg     [  1: 0] pio_right_s1_arb_share_counter;
  wire    [  1: 0] pio_right_s1_arb_share_counter_next_value;
  wire    [  1: 0] pio_right_s1_arb_share_set_values;
  wire             pio_right_s1_beginbursttransfer_internal;
  wire             pio_right_s1_begins_xfer;
  wire             pio_right_s1_chipselect;
  wire             pio_right_s1_end_xfer;
  wire             pio_right_s1_firsttransfer;
  wire             pio_right_s1_grant_vector;
  wire             pio_right_s1_in_a_read_cycle;
  wire             pio_right_s1_in_a_write_cycle;
  wire             pio_right_s1_master_qreq_vector;
  wire             pio_right_s1_non_bursting_master_requests;
  wire    [ 31: 0] pio_right_s1_readdata_from_sa;
  reg              pio_right_s1_reg_firsttransfer;
  wire             pio_right_s1_reset_n;
  reg              pio_right_s1_slavearbiterlockenable;
  wire             pio_right_s1_slavearbiterlockenable2;
  wire             pio_right_s1_unreg_firsttransfer;
  wire             pio_right_s1_waits_for_read;
  wire             pio_right_s1_waits_for_write;
  wire             pio_right_s1_write_n;
  wire    [ 31: 0] pio_right_s1_writedata;
  wire    [ 20: 0] shifted_address_to_pio_right_s1_from_cpu_data_master;
  wire             wait_for_pio_right_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~pio_right_s1_end_xfer;
    end


  assign pio_right_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_pio_right_s1));
  //assign pio_right_s1_readdata_from_sa = pio_right_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign pio_right_s1_readdata_from_sa = pio_right_s1_readdata;

  assign cpu_data_master_requests_pio_right_s1 = ({cpu_data_master_address_to_slave[20 : 4] , 4'b0} == 21'h101050) & (cpu_data_master_read | cpu_data_master_write);
  //pio_right_s1_arb_share_counter set values, which is an e_mux
  assign pio_right_s1_arb_share_set_values = 1;

  //pio_right_s1_non_bursting_master_requests mux, which is an e_mux
  assign pio_right_s1_non_bursting_master_requests = cpu_data_master_requests_pio_right_s1;

  //pio_right_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign pio_right_s1_any_bursting_master_saved_grant = 0;

  //pio_right_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign pio_right_s1_arb_share_counter_next_value = pio_right_s1_firsttransfer ? (pio_right_s1_arb_share_set_values - 1) : |pio_right_s1_arb_share_counter ? (pio_right_s1_arb_share_counter - 1) : 0;

  //pio_right_s1_allgrants all slave grants, which is an e_mux
  assign pio_right_s1_allgrants = |pio_right_s1_grant_vector;

  //pio_right_s1_end_xfer assignment, which is an e_assign
  assign pio_right_s1_end_xfer = ~(pio_right_s1_waits_for_read | pio_right_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_pio_right_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_pio_right_s1 = pio_right_s1_end_xfer & (~pio_right_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //pio_right_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign pio_right_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_pio_right_s1 & pio_right_s1_allgrants) | (end_xfer_arb_share_counter_term_pio_right_s1 & ~pio_right_s1_non_bursting_master_requests);

  //pio_right_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_right_s1_arb_share_counter <= 0;
      else if (pio_right_s1_arb_counter_enable)
          pio_right_s1_arb_share_counter <= pio_right_s1_arb_share_counter_next_value;
    end


  //pio_right_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_right_s1_slavearbiterlockenable <= 0;
      else if ((|pio_right_s1_master_qreq_vector & end_xfer_arb_share_counter_term_pio_right_s1) | (end_xfer_arb_share_counter_term_pio_right_s1 & ~pio_right_s1_non_bursting_master_requests))
          pio_right_s1_slavearbiterlockenable <= |pio_right_s1_arb_share_counter_next_value;
    end


  //cpu/data_master pio_right/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = pio_right_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //pio_right_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign pio_right_s1_slavearbiterlockenable2 = |pio_right_s1_arb_share_counter_next_value;

  //cpu/data_master pio_right/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = pio_right_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //pio_right_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign pio_right_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_pio_right_s1 = cpu_data_master_requests_pio_right_s1 & ~(((~cpu_data_master_waitrequest) & cpu_data_master_write));
  //pio_right_s1_writedata mux, which is an e_mux
  assign pio_right_s1_writedata = cpu_data_master_writedata;

  //master is always granted when requested
  assign cpu_data_master_granted_pio_right_s1 = cpu_data_master_qualified_request_pio_right_s1;

  //cpu/data_master saved-grant pio_right/s1, which is an e_assign
  assign cpu_data_master_saved_grant_pio_right_s1 = cpu_data_master_requests_pio_right_s1;

  //allow new arb cycle for pio_right/s1, which is an e_assign
  assign pio_right_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign pio_right_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign pio_right_s1_master_qreq_vector = 1;

  //pio_right_s1_reset_n assignment, which is an e_assign
  assign pio_right_s1_reset_n = reset_n;

  assign pio_right_s1_chipselect = cpu_data_master_granted_pio_right_s1;
  //pio_right_s1_firsttransfer first transaction, which is an e_assign
  assign pio_right_s1_firsttransfer = pio_right_s1_begins_xfer ? pio_right_s1_unreg_firsttransfer : pio_right_s1_reg_firsttransfer;

  //pio_right_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign pio_right_s1_unreg_firsttransfer = ~(pio_right_s1_slavearbiterlockenable & pio_right_s1_any_continuerequest);

  //pio_right_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_right_s1_reg_firsttransfer <= 1'b1;
      else if (pio_right_s1_begins_xfer)
          pio_right_s1_reg_firsttransfer <= pio_right_s1_unreg_firsttransfer;
    end


  //pio_right_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign pio_right_s1_beginbursttransfer_internal = pio_right_s1_begins_xfer;

  //~pio_right_s1_write_n assignment, which is an e_mux
  assign pio_right_s1_write_n = ~(cpu_data_master_granted_pio_right_s1 & cpu_data_master_write);

  assign shifted_address_to_pio_right_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //pio_right_s1_address mux, which is an e_mux
  assign pio_right_s1_address = shifted_address_to_pio_right_s1_from_cpu_data_master >> 2;

  //d1_pio_right_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_pio_right_s1_end_xfer <= 1;
      else 
        d1_pio_right_s1_end_xfer <= pio_right_s1_end_xfer;
    end


  //pio_right_s1_waits_for_read in a cycle, which is an e_mux
  assign pio_right_s1_waits_for_read = pio_right_s1_in_a_read_cycle & pio_right_s1_begins_xfer;

  //pio_right_s1_in_a_read_cycle assignment, which is an e_assign
  assign pio_right_s1_in_a_read_cycle = cpu_data_master_granted_pio_right_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = pio_right_s1_in_a_read_cycle;

  //pio_right_s1_waits_for_write in a cycle, which is an e_mux
  assign pio_right_s1_waits_for_write = pio_right_s1_in_a_write_cycle & 0;

  //pio_right_s1_in_a_write_cycle assignment, which is an e_assign
  assign pio_right_s1_in_a_write_cycle = cpu_data_master_granted_pio_right_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = pio_right_s1_in_a_write_cycle;

  assign wait_for_pio_right_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //pio_right/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module pio_sw_s1_arbitrator (
                              // inputs:
                               clk,
                               cpu_data_master_address_to_slave,
                               cpu_data_master_read,
                               cpu_data_master_write,
                               pio_sw_s1_readdata,
                               reset_n,

                              // outputs:
                               cpu_data_master_granted_pio_sw_s1,
                               cpu_data_master_qualified_request_pio_sw_s1,
                               cpu_data_master_read_data_valid_pio_sw_s1,
                               cpu_data_master_requests_pio_sw_s1,
                               d1_pio_sw_s1_end_xfer,
                               pio_sw_s1_address,
                               pio_sw_s1_readdata_from_sa,
                               pio_sw_s1_reset_n
                            )
;

  output           cpu_data_master_granted_pio_sw_s1;
  output           cpu_data_master_qualified_request_pio_sw_s1;
  output           cpu_data_master_read_data_valid_pio_sw_s1;
  output           cpu_data_master_requests_pio_sw_s1;
  output           d1_pio_sw_s1_end_xfer;
  output  [  1: 0] pio_sw_s1_address;
  output  [ 31: 0] pio_sw_s1_readdata_from_sa;
  output           pio_sw_s1_reset_n;
  input            clk;
  input   [ 20: 0] cpu_data_master_address_to_slave;
  input            cpu_data_master_read;
  input            cpu_data_master_write;
  input   [ 31: 0] pio_sw_s1_readdata;
  input            reset_n;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_pio_sw_s1;
  wire             cpu_data_master_qualified_request_pio_sw_s1;
  wire             cpu_data_master_read_data_valid_pio_sw_s1;
  wire             cpu_data_master_requests_pio_sw_s1;
  wire             cpu_data_master_saved_grant_pio_sw_s1;
  reg              d1_pio_sw_s1_end_xfer;
  reg              d1_reasons_to_wait;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_pio_sw_s1;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] pio_sw_s1_address;
  wire             pio_sw_s1_allgrants;
  wire             pio_sw_s1_allow_new_arb_cycle;
  wire             pio_sw_s1_any_bursting_master_saved_grant;
  wire             pio_sw_s1_any_continuerequest;
  wire             pio_sw_s1_arb_counter_enable;
  reg     [  1: 0] pio_sw_s1_arb_share_counter;
  wire    [  1: 0] pio_sw_s1_arb_share_counter_next_value;
  wire    [  1: 0] pio_sw_s1_arb_share_set_values;
  wire             pio_sw_s1_beginbursttransfer_internal;
  wire             pio_sw_s1_begins_xfer;
  wire             pio_sw_s1_end_xfer;
  wire             pio_sw_s1_firsttransfer;
  wire             pio_sw_s1_grant_vector;
  wire             pio_sw_s1_in_a_read_cycle;
  wire             pio_sw_s1_in_a_write_cycle;
  wire             pio_sw_s1_master_qreq_vector;
  wire             pio_sw_s1_non_bursting_master_requests;
  wire    [ 31: 0] pio_sw_s1_readdata_from_sa;
  reg              pio_sw_s1_reg_firsttransfer;
  wire             pio_sw_s1_reset_n;
  reg              pio_sw_s1_slavearbiterlockenable;
  wire             pio_sw_s1_slavearbiterlockenable2;
  wire             pio_sw_s1_unreg_firsttransfer;
  wire             pio_sw_s1_waits_for_read;
  wire             pio_sw_s1_waits_for_write;
  wire    [ 20: 0] shifted_address_to_pio_sw_s1_from_cpu_data_master;
  wire             wait_for_pio_sw_s1_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~pio_sw_s1_end_xfer;
    end


  assign pio_sw_s1_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_pio_sw_s1));
  //assign pio_sw_s1_readdata_from_sa = pio_sw_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign pio_sw_s1_readdata_from_sa = pio_sw_s1_readdata;

  assign cpu_data_master_requests_pio_sw_s1 = (({cpu_data_master_address_to_slave[20 : 4] , 4'b0} == 21'h101010) & (cpu_data_master_read | cpu_data_master_write)) & cpu_data_master_read;
  //pio_sw_s1_arb_share_counter set values, which is an e_mux
  assign pio_sw_s1_arb_share_set_values = 1;

  //pio_sw_s1_non_bursting_master_requests mux, which is an e_mux
  assign pio_sw_s1_non_bursting_master_requests = cpu_data_master_requests_pio_sw_s1;

  //pio_sw_s1_any_bursting_master_saved_grant mux, which is an e_mux
  assign pio_sw_s1_any_bursting_master_saved_grant = 0;

  //pio_sw_s1_arb_share_counter_next_value assignment, which is an e_assign
  assign pio_sw_s1_arb_share_counter_next_value = pio_sw_s1_firsttransfer ? (pio_sw_s1_arb_share_set_values - 1) : |pio_sw_s1_arb_share_counter ? (pio_sw_s1_arb_share_counter - 1) : 0;

  //pio_sw_s1_allgrants all slave grants, which is an e_mux
  assign pio_sw_s1_allgrants = |pio_sw_s1_grant_vector;

  //pio_sw_s1_end_xfer assignment, which is an e_assign
  assign pio_sw_s1_end_xfer = ~(pio_sw_s1_waits_for_read | pio_sw_s1_waits_for_write);

  //end_xfer_arb_share_counter_term_pio_sw_s1 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_pio_sw_s1 = pio_sw_s1_end_xfer & (~pio_sw_s1_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //pio_sw_s1_arb_share_counter arbitration counter enable, which is an e_assign
  assign pio_sw_s1_arb_counter_enable = (end_xfer_arb_share_counter_term_pio_sw_s1 & pio_sw_s1_allgrants) | (end_xfer_arb_share_counter_term_pio_sw_s1 & ~pio_sw_s1_non_bursting_master_requests);

  //pio_sw_s1_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_sw_s1_arb_share_counter <= 0;
      else if (pio_sw_s1_arb_counter_enable)
          pio_sw_s1_arb_share_counter <= pio_sw_s1_arb_share_counter_next_value;
    end


  //pio_sw_s1_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_sw_s1_slavearbiterlockenable <= 0;
      else if ((|pio_sw_s1_master_qreq_vector & end_xfer_arb_share_counter_term_pio_sw_s1) | (end_xfer_arb_share_counter_term_pio_sw_s1 & ~pio_sw_s1_non_bursting_master_requests))
          pio_sw_s1_slavearbiterlockenable <= |pio_sw_s1_arb_share_counter_next_value;
    end


  //cpu/data_master pio_sw/s1 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = pio_sw_s1_slavearbiterlockenable & cpu_data_master_continuerequest;

  //pio_sw_s1_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign pio_sw_s1_slavearbiterlockenable2 = |pio_sw_s1_arb_share_counter_next_value;

  //cpu/data_master pio_sw/s1 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = pio_sw_s1_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //pio_sw_s1_any_continuerequest at least one master continues requesting, which is an e_assign
  assign pio_sw_s1_any_continuerequest = 1;

  //cpu_data_master_continuerequest continued request, which is an e_assign
  assign cpu_data_master_continuerequest = 1;

  assign cpu_data_master_qualified_request_pio_sw_s1 = cpu_data_master_requests_pio_sw_s1;
  //master is always granted when requested
  assign cpu_data_master_granted_pio_sw_s1 = cpu_data_master_qualified_request_pio_sw_s1;

  //cpu/data_master saved-grant pio_sw/s1, which is an e_assign
  assign cpu_data_master_saved_grant_pio_sw_s1 = cpu_data_master_requests_pio_sw_s1;

  //allow new arb cycle for pio_sw/s1, which is an e_assign
  assign pio_sw_s1_allow_new_arb_cycle = 1;

  //placeholder chosen master
  assign pio_sw_s1_grant_vector = 1;

  //placeholder vector of master qualified-requests
  assign pio_sw_s1_master_qreq_vector = 1;

  //pio_sw_s1_reset_n assignment, which is an e_assign
  assign pio_sw_s1_reset_n = reset_n;

  //pio_sw_s1_firsttransfer first transaction, which is an e_assign
  assign pio_sw_s1_firsttransfer = pio_sw_s1_begins_xfer ? pio_sw_s1_unreg_firsttransfer : pio_sw_s1_reg_firsttransfer;

  //pio_sw_s1_unreg_firsttransfer first transaction, which is an e_assign
  assign pio_sw_s1_unreg_firsttransfer = ~(pio_sw_s1_slavearbiterlockenable & pio_sw_s1_any_continuerequest);

  //pio_sw_s1_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          pio_sw_s1_reg_firsttransfer <= 1'b1;
      else if (pio_sw_s1_begins_xfer)
          pio_sw_s1_reg_firsttransfer <= pio_sw_s1_unreg_firsttransfer;
    end


  //pio_sw_s1_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign pio_sw_s1_beginbursttransfer_internal = pio_sw_s1_begins_xfer;

  assign shifted_address_to_pio_sw_s1_from_cpu_data_master = cpu_data_master_address_to_slave;
  //pio_sw_s1_address mux, which is an e_mux
  assign pio_sw_s1_address = shifted_address_to_pio_sw_s1_from_cpu_data_master >> 2;

  //d1_pio_sw_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_pio_sw_s1_end_xfer <= 1;
      else 
        d1_pio_sw_s1_end_xfer <= pio_sw_s1_end_xfer;
    end


  //pio_sw_s1_waits_for_read in a cycle, which is an e_mux
  assign pio_sw_s1_waits_for_read = pio_sw_s1_in_a_read_cycle & pio_sw_s1_begins_xfer;

  //pio_sw_s1_in_a_read_cycle assignment, which is an e_assign
  assign pio_sw_s1_in_a_read_cycle = cpu_data_master_granted_pio_sw_s1 & cpu_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = pio_sw_s1_in_a_read_cycle;

  //pio_sw_s1_waits_for_write in a cycle, which is an e_mux
  assign pio_sw_s1_waits_for_write = pio_sw_s1_in_a_write_cycle & 0;

  //pio_sw_s1_in_a_write_cycle assignment, which is an e_assign
  assign pio_sw_s1_in_a_write_cycle = cpu_data_master_granted_pio_sw_s1 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = pio_sw_s1_in_a_write_cycle;

  assign wait_for_pio_sw_s1_counter = 0;

//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //pio_sw/s1 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module sram_16bit_512k_0_avalon_slave_0_arbitrator (
                                                     // inputs:
                                                      clk,
                                                      cpu_data_master_address_to_slave,
                                                      cpu_data_master_byteenable,
                                                      cpu_data_master_dbs_address,
                                                      cpu_data_master_dbs_write_16,
                                                      cpu_data_master_no_byte_enables_and_last_term,
                                                      cpu_data_master_read,
                                                      cpu_data_master_write,
                                                      cpu_instruction_master_address_to_slave,
                                                      cpu_instruction_master_dbs_address,
                                                      cpu_instruction_master_latency_counter,
                                                      cpu_instruction_master_read,
                                                      reset_n,
                                                      sram_16bit_512k_0_avalon_slave_0_readdata,

                                                     // outputs:
                                                      cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0,
                                                      cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0,
                                                      cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0,
                                                      cpu_data_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0,
                                                      cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0,
                                                      cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0,
                                                      cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0,
                                                      cpu_instruction_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0,
                                                      cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0,
                                                      d1_sram_16bit_512k_0_avalon_slave_0_end_xfer,
                                                      sram_16bit_512k_0_avalon_slave_0_address,
                                                      sram_16bit_512k_0_avalon_slave_0_byteenable_n,
                                                      sram_16bit_512k_0_avalon_slave_0_chipselect_n,
                                                      sram_16bit_512k_0_avalon_slave_0_read_n,
                                                      sram_16bit_512k_0_avalon_slave_0_readdata_from_sa,
                                                      sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0,
                                                      sram_16bit_512k_0_avalon_slave_0_write_n,
                                                      sram_16bit_512k_0_avalon_slave_0_writedata
                                                   )
;

  output  [  1: 0] cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0;
  output           cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0;
  output           cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0;
  output           cpu_data_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0;
  output           cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0;
  output           cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0;
  output           cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0;
  output           cpu_instruction_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0;
  output           cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0;
  output           d1_sram_16bit_512k_0_avalon_slave_0_end_xfer;
  output  [ 17: 0] sram_16bit_512k_0_avalon_slave_0_address;
  output  [  1: 0] sram_16bit_512k_0_avalon_slave_0_byteenable_n;
  output           sram_16bit_512k_0_avalon_slave_0_chipselect_n;
  output           sram_16bit_512k_0_avalon_slave_0_read_n;
  output  [ 15: 0] sram_16bit_512k_0_avalon_slave_0_readdata_from_sa;
  output           sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0;
  output           sram_16bit_512k_0_avalon_slave_0_write_n;
  output  [ 15: 0] sram_16bit_512k_0_avalon_slave_0_writedata;
  input            clk;
  input   [ 20: 0] cpu_data_master_address_to_slave;
  input   [  3: 0] cpu_data_master_byteenable;
  input   [  1: 0] cpu_data_master_dbs_address;
  input   [ 15: 0] cpu_data_master_dbs_write_16;
  input            cpu_data_master_no_byte_enables_and_last_term;
  input            cpu_data_master_read;
  input            cpu_data_master_write;
  input   [ 20: 0] cpu_instruction_master_address_to_slave;
  input   [  1: 0] cpu_instruction_master_dbs_address;
  input            cpu_instruction_master_latency_counter;
  input            cpu_instruction_master_read;
  input            reset_n;
  input   [ 15: 0] sram_16bit_512k_0_avalon_slave_0_readdata;

  wire             cpu_data_master_arbiterlock;
  wire             cpu_data_master_arbiterlock2;
  wire    [  1: 0] cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0;
  wire    [  1: 0] cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0_segment_0;
  wire    [  1: 0] cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0_segment_1;
  wire             cpu_data_master_continuerequest;
  wire             cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_data_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_data_master_saved_grant_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_instruction_master_arbiterlock;
  wire             cpu_instruction_master_arbiterlock2;
  wire             cpu_instruction_master_continuerequest;
  wire             cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_instruction_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_instruction_master_saved_grant_sram_16bit_512k_0_avalon_slave_0;
  reg              d1_reasons_to_wait;
  reg              d1_sram_16bit_512k_0_avalon_slave_0_end_xfer;
  reg              enable_nonzero_assertions;
  wire             end_xfer_arb_share_counter_term_sram_16bit_512k_0_avalon_slave_0;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  reg              last_cycle_cpu_data_master_granted_slave_sram_16bit_512k_0_avalon_slave_0;
  reg              last_cycle_cpu_instruction_master_granted_slave_sram_16bit_512k_0_avalon_slave_0;
  wire    [ 20: 0] shifted_address_to_sram_16bit_512k_0_avalon_slave_0_from_cpu_data_master;
  wire    [ 20: 0] shifted_address_to_sram_16bit_512k_0_avalon_slave_0_from_cpu_instruction_master;
  wire    [ 17: 0] sram_16bit_512k_0_avalon_slave_0_address;
  wire             sram_16bit_512k_0_avalon_slave_0_allgrants;
  wire             sram_16bit_512k_0_avalon_slave_0_allow_new_arb_cycle;
  wire             sram_16bit_512k_0_avalon_slave_0_any_bursting_master_saved_grant;
  wire             sram_16bit_512k_0_avalon_slave_0_any_continuerequest;
  reg     [  1: 0] sram_16bit_512k_0_avalon_slave_0_arb_addend;
  wire             sram_16bit_512k_0_avalon_slave_0_arb_counter_enable;
  reg     [  1: 0] sram_16bit_512k_0_avalon_slave_0_arb_share_counter;
  wire    [  1: 0] sram_16bit_512k_0_avalon_slave_0_arb_share_counter_next_value;
  wire    [  1: 0] sram_16bit_512k_0_avalon_slave_0_arb_share_set_values;
  wire    [  1: 0] sram_16bit_512k_0_avalon_slave_0_arb_winner;
  wire             sram_16bit_512k_0_avalon_slave_0_arbitration_holdoff_internal;
  wire             sram_16bit_512k_0_avalon_slave_0_beginbursttransfer_internal;
  wire             sram_16bit_512k_0_avalon_slave_0_begins_xfer;
  wire    [  1: 0] sram_16bit_512k_0_avalon_slave_0_byteenable_n;
  wire             sram_16bit_512k_0_avalon_slave_0_chipselect_n;
  wire    [  3: 0] sram_16bit_512k_0_avalon_slave_0_chosen_master_double_vector;
  wire    [  1: 0] sram_16bit_512k_0_avalon_slave_0_chosen_master_rot_left;
  wire             sram_16bit_512k_0_avalon_slave_0_counter_load_value;
  wire             sram_16bit_512k_0_avalon_slave_0_end_xfer;
  wire             sram_16bit_512k_0_avalon_slave_0_firsttransfer;
  wire    [  1: 0] sram_16bit_512k_0_avalon_slave_0_grant_vector;
  wire             sram_16bit_512k_0_avalon_slave_0_in_a_read_cycle;
  wire             sram_16bit_512k_0_avalon_slave_0_in_a_write_cycle;
  wire    [  1: 0] sram_16bit_512k_0_avalon_slave_0_master_qreq_vector;
  wire             sram_16bit_512k_0_avalon_slave_0_non_bursting_master_requests;
  wire             sram_16bit_512k_0_avalon_slave_0_read_n;
  wire    [ 15: 0] sram_16bit_512k_0_avalon_slave_0_readdata_from_sa;
  reg              sram_16bit_512k_0_avalon_slave_0_reg_firsttransfer;
  reg     [  1: 0] sram_16bit_512k_0_avalon_slave_0_saved_chosen_master_vector;
  reg              sram_16bit_512k_0_avalon_slave_0_slavearbiterlockenable;
  wire             sram_16bit_512k_0_avalon_slave_0_slavearbiterlockenable2;
  wire             sram_16bit_512k_0_avalon_slave_0_unreg_firsttransfer;
  reg              sram_16bit_512k_0_avalon_slave_0_wait_counter;
  wire             sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0;
  wire             sram_16bit_512k_0_avalon_slave_0_waits_for_read;
  wire             sram_16bit_512k_0_avalon_slave_0_waits_for_write;
  wire             sram_16bit_512k_0_avalon_slave_0_write_n;
  wire    [ 15: 0] sram_16bit_512k_0_avalon_slave_0_writedata;
  wire             wait_for_sram_16bit_512k_0_avalon_slave_0_counter;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_reasons_to_wait <= 0;
      else 
        d1_reasons_to_wait <= ~sram_16bit_512k_0_avalon_slave_0_end_xfer;
    end


  assign sram_16bit_512k_0_avalon_slave_0_begins_xfer = ~d1_reasons_to_wait & ((cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0 | cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0));
  //assign sram_16bit_512k_0_avalon_slave_0_readdata_from_sa = sram_16bit_512k_0_avalon_slave_0_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_readdata_from_sa = sram_16bit_512k_0_avalon_slave_0_readdata;

  assign cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0 = ({cpu_data_master_address_to_slave[20 : 19] , 19'b0} == 21'h80000) & (cpu_data_master_read | cpu_data_master_write);
  //sram_16bit_512k_0_avalon_slave_0_arb_share_counter set values, which is an e_mux
  assign sram_16bit_512k_0_avalon_slave_0_arb_share_set_values = (cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0)? 2 :
    (cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0)? 2 :
    (cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0)? 2 :
    (cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0)? 2 :
    1;

  //sram_16bit_512k_0_avalon_slave_0_non_bursting_master_requests mux, which is an e_mux
  assign sram_16bit_512k_0_avalon_slave_0_non_bursting_master_requests = cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0 |
    cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0 |
    cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0 |
    cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0;

  //sram_16bit_512k_0_avalon_slave_0_any_bursting_master_saved_grant mux, which is an e_mux
  assign sram_16bit_512k_0_avalon_slave_0_any_bursting_master_saved_grant = 0;

  //sram_16bit_512k_0_avalon_slave_0_arb_share_counter_next_value assignment, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_arb_share_counter_next_value = sram_16bit_512k_0_avalon_slave_0_firsttransfer ? (sram_16bit_512k_0_avalon_slave_0_arb_share_set_values - 1) : |sram_16bit_512k_0_avalon_slave_0_arb_share_counter ? (sram_16bit_512k_0_avalon_slave_0_arb_share_counter - 1) : 0;

  //sram_16bit_512k_0_avalon_slave_0_allgrants all slave grants, which is an e_mux
  assign sram_16bit_512k_0_avalon_slave_0_allgrants = (|sram_16bit_512k_0_avalon_slave_0_grant_vector) |
    (|sram_16bit_512k_0_avalon_slave_0_grant_vector) |
    (|sram_16bit_512k_0_avalon_slave_0_grant_vector) |
    (|sram_16bit_512k_0_avalon_slave_0_grant_vector);

  //sram_16bit_512k_0_avalon_slave_0_end_xfer assignment, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_end_xfer = ~(sram_16bit_512k_0_avalon_slave_0_waits_for_read | sram_16bit_512k_0_avalon_slave_0_waits_for_write);

  //end_xfer_arb_share_counter_term_sram_16bit_512k_0_avalon_slave_0 arb share counter enable term, which is an e_assign
  assign end_xfer_arb_share_counter_term_sram_16bit_512k_0_avalon_slave_0 = sram_16bit_512k_0_avalon_slave_0_end_xfer & (~sram_16bit_512k_0_avalon_slave_0_any_bursting_master_saved_grant | in_a_read_cycle | in_a_write_cycle);

  //sram_16bit_512k_0_avalon_slave_0_arb_share_counter arbitration counter enable, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_arb_counter_enable = (end_xfer_arb_share_counter_term_sram_16bit_512k_0_avalon_slave_0 & sram_16bit_512k_0_avalon_slave_0_allgrants) | (end_xfer_arb_share_counter_term_sram_16bit_512k_0_avalon_slave_0 & ~sram_16bit_512k_0_avalon_slave_0_non_bursting_master_requests);

  //sram_16bit_512k_0_avalon_slave_0_arb_share_counter counter, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sram_16bit_512k_0_avalon_slave_0_arb_share_counter <= 0;
      else if (sram_16bit_512k_0_avalon_slave_0_arb_counter_enable)
          sram_16bit_512k_0_avalon_slave_0_arb_share_counter <= sram_16bit_512k_0_avalon_slave_0_arb_share_counter_next_value;
    end


  //sram_16bit_512k_0_avalon_slave_0_slavearbiterlockenable slave enables arbiterlock, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sram_16bit_512k_0_avalon_slave_0_slavearbiterlockenable <= 0;
      else if ((|sram_16bit_512k_0_avalon_slave_0_master_qreq_vector & end_xfer_arb_share_counter_term_sram_16bit_512k_0_avalon_slave_0) | (end_xfer_arb_share_counter_term_sram_16bit_512k_0_avalon_slave_0 & ~sram_16bit_512k_0_avalon_slave_0_non_bursting_master_requests))
          sram_16bit_512k_0_avalon_slave_0_slavearbiterlockenable <= |sram_16bit_512k_0_avalon_slave_0_arb_share_counter_next_value;
    end


  //cpu/data_master sram_16bit_512k_0/avalon_slave_0 arbiterlock, which is an e_assign
  assign cpu_data_master_arbiterlock = sram_16bit_512k_0_avalon_slave_0_slavearbiterlockenable & cpu_data_master_continuerequest;

  //sram_16bit_512k_0_avalon_slave_0_slavearbiterlockenable2 slave enables arbiterlock2, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_slavearbiterlockenable2 = |sram_16bit_512k_0_avalon_slave_0_arb_share_counter_next_value;

  //cpu/data_master sram_16bit_512k_0/avalon_slave_0 arbiterlock2, which is an e_assign
  assign cpu_data_master_arbiterlock2 = sram_16bit_512k_0_avalon_slave_0_slavearbiterlockenable2 & cpu_data_master_continuerequest;

  //cpu/instruction_master sram_16bit_512k_0/avalon_slave_0 arbiterlock, which is an e_assign
  assign cpu_instruction_master_arbiterlock = sram_16bit_512k_0_avalon_slave_0_slavearbiterlockenable & cpu_instruction_master_continuerequest;

  //cpu/instruction_master sram_16bit_512k_0/avalon_slave_0 arbiterlock2, which is an e_assign
  assign cpu_instruction_master_arbiterlock2 = sram_16bit_512k_0_avalon_slave_0_slavearbiterlockenable2 & cpu_instruction_master_continuerequest;

  //cpu/instruction_master granted sram_16bit_512k_0/avalon_slave_0 last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_cpu_instruction_master_granted_slave_sram_16bit_512k_0_avalon_slave_0 <= 0;
      else 
        last_cycle_cpu_instruction_master_granted_slave_sram_16bit_512k_0_avalon_slave_0 <= cpu_instruction_master_saved_grant_sram_16bit_512k_0_avalon_slave_0 ? 1 : (sram_16bit_512k_0_avalon_slave_0_arbitration_holdoff_internal | ~cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0) ? 0 : last_cycle_cpu_instruction_master_granted_slave_sram_16bit_512k_0_avalon_slave_0;
    end


  //cpu_instruction_master_continuerequest continued request, which is an e_mux
  assign cpu_instruction_master_continuerequest = last_cycle_cpu_instruction_master_granted_slave_sram_16bit_512k_0_avalon_slave_0 & cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0;

  //sram_16bit_512k_0_avalon_slave_0_any_continuerequest at least one master continues requesting, which is an e_mux
  assign sram_16bit_512k_0_avalon_slave_0_any_continuerequest = cpu_instruction_master_continuerequest |
    cpu_data_master_continuerequest;

  assign cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0 = cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0 & ~(((cpu_data_master_no_byte_enables_and_last_term | !cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0) & cpu_data_master_write) | cpu_instruction_master_arbiterlock);
  //sram_16bit_512k_0_avalon_slave_0_writedata mux, which is an e_mux
  assign sram_16bit_512k_0_avalon_slave_0_writedata = cpu_data_master_dbs_write_16;

  assign cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0 = (({cpu_instruction_master_address_to_slave[20 : 19] , 19'b0} == 21'h80000) & (cpu_instruction_master_read)) & cpu_instruction_master_read;
  //cpu/data_master granted sram_16bit_512k_0/avalon_slave_0 last time, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          last_cycle_cpu_data_master_granted_slave_sram_16bit_512k_0_avalon_slave_0 <= 0;
      else 
        last_cycle_cpu_data_master_granted_slave_sram_16bit_512k_0_avalon_slave_0 <= cpu_data_master_saved_grant_sram_16bit_512k_0_avalon_slave_0 ? 1 : (sram_16bit_512k_0_avalon_slave_0_arbitration_holdoff_internal | ~cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0) ? 0 : last_cycle_cpu_data_master_granted_slave_sram_16bit_512k_0_avalon_slave_0;
    end


  //cpu_data_master_continuerequest continued request, which is an e_mux
  assign cpu_data_master_continuerequest = last_cycle_cpu_data_master_granted_slave_sram_16bit_512k_0_avalon_slave_0 & cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0;

  assign cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0 = cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0 & ~((cpu_instruction_master_read & ((cpu_instruction_master_latency_counter != 0))) | cpu_data_master_arbiterlock);
  //local readdatavalid cpu_instruction_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0, which is an e_mux
  assign cpu_instruction_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0 = cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0 & cpu_instruction_master_read & ~sram_16bit_512k_0_avalon_slave_0_waits_for_read;

  //allow new arb cycle for sram_16bit_512k_0/avalon_slave_0, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_allow_new_arb_cycle = ~cpu_data_master_arbiterlock & ~cpu_instruction_master_arbiterlock;

  //cpu/instruction_master assignment into master qualified-requests vector for sram_16bit_512k_0/avalon_slave_0, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_master_qreq_vector[0] = cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0;

  //cpu/instruction_master grant sram_16bit_512k_0/avalon_slave_0, which is an e_assign
  assign cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0 = sram_16bit_512k_0_avalon_slave_0_grant_vector[0];

  //cpu/instruction_master saved-grant sram_16bit_512k_0/avalon_slave_0, which is an e_assign
  assign cpu_instruction_master_saved_grant_sram_16bit_512k_0_avalon_slave_0 = sram_16bit_512k_0_avalon_slave_0_arb_winner[0] && cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0;

  //cpu/data_master assignment into master qualified-requests vector for sram_16bit_512k_0/avalon_slave_0, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_master_qreq_vector[1] = cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0;

  //cpu/data_master grant sram_16bit_512k_0/avalon_slave_0, which is an e_assign
  assign cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0 = sram_16bit_512k_0_avalon_slave_0_grant_vector[1];

  //cpu/data_master saved-grant sram_16bit_512k_0/avalon_slave_0, which is an e_assign
  assign cpu_data_master_saved_grant_sram_16bit_512k_0_avalon_slave_0 = sram_16bit_512k_0_avalon_slave_0_arb_winner[1] && cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0;

  //sram_16bit_512k_0/avalon_slave_0 chosen-master double-vector, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_chosen_master_double_vector = {sram_16bit_512k_0_avalon_slave_0_master_qreq_vector, sram_16bit_512k_0_avalon_slave_0_master_qreq_vector} & ({~sram_16bit_512k_0_avalon_slave_0_master_qreq_vector, ~sram_16bit_512k_0_avalon_slave_0_master_qreq_vector} + sram_16bit_512k_0_avalon_slave_0_arb_addend);

  //stable onehot encoding of arb winner
  assign sram_16bit_512k_0_avalon_slave_0_arb_winner = (sram_16bit_512k_0_avalon_slave_0_allow_new_arb_cycle & | sram_16bit_512k_0_avalon_slave_0_grant_vector) ? sram_16bit_512k_0_avalon_slave_0_grant_vector : sram_16bit_512k_0_avalon_slave_0_saved_chosen_master_vector;

  //saved sram_16bit_512k_0_avalon_slave_0_grant_vector, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sram_16bit_512k_0_avalon_slave_0_saved_chosen_master_vector <= 0;
      else if (sram_16bit_512k_0_avalon_slave_0_allow_new_arb_cycle)
          sram_16bit_512k_0_avalon_slave_0_saved_chosen_master_vector <= |sram_16bit_512k_0_avalon_slave_0_grant_vector ? sram_16bit_512k_0_avalon_slave_0_grant_vector : sram_16bit_512k_0_avalon_slave_0_saved_chosen_master_vector;
    end


  //onehot encoding of chosen master
  assign sram_16bit_512k_0_avalon_slave_0_grant_vector = {(sram_16bit_512k_0_avalon_slave_0_chosen_master_double_vector[1] | sram_16bit_512k_0_avalon_slave_0_chosen_master_double_vector[3]),
    (sram_16bit_512k_0_avalon_slave_0_chosen_master_double_vector[0] | sram_16bit_512k_0_avalon_slave_0_chosen_master_double_vector[2])};

  //sram_16bit_512k_0/avalon_slave_0 chosen master rotated left, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_chosen_master_rot_left = (sram_16bit_512k_0_avalon_slave_0_arb_winner << 1) ? (sram_16bit_512k_0_avalon_slave_0_arb_winner << 1) : 1;

  //sram_16bit_512k_0/avalon_slave_0's addend for next-master-grant
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sram_16bit_512k_0_avalon_slave_0_arb_addend <= 1;
      else if (|sram_16bit_512k_0_avalon_slave_0_grant_vector)
          sram_16bit_512k_0_avalon_slave_0_arb_addend <= sram_16bit_512k_0_avalon_slave_0_end_xfer? sram_16bit_512k_0_avalon_slave_0_chosen_master_rot_left : sram_16bit_512k_0_avalon_slave_0_grant_vector;
    end


  assign sram_16bit_512k_0_avalon_slave_0_chipselect_n = ~(cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0 | cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0);
  //sram_16bit_512k_0_avalon_slave_0_firsttransfer first transaction, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_firsttransfer = sram_16bit_512k_0_avalon_slave_0_begins_xfer ? sram_16bit_512k_0_avalon_slave_0_unreg_firsttransfer : sram_16bit_512k_0_avalon_slave_0_reg_firsttransfer;

  //sram_16bit_512k_0_avalon_slave_0_unreg_firsttransfer first transaction, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_unreg_firsttransfer = ~(sram_16bit_512k_0_avalon_slave_0_slavearbiterlockenable & sram_16bit_512k_0_avalon_slave_0_any_continuerequest);

  //sram_16bit_512k_0_avalon_slave_0_reg_firsttransfer first transaction, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sram_16bit_512k_0_avalon_slave_0_reg_firsttransfer <= 1'b1;
      else if (sram_16bit_512k_0_avalon_slave_0_begins_xfer)
          sram_16bit_512k_0_avalon_slave_0_reg_firsttransfer <= sram_16bit_512k_0_avalon_slave_0_unreg_firsttransfer;
    end


  //sram_16bit_512k_0_avalon_slave_0_beginbursttransfer_internal begin burst transfer, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_beginbursttransfer_internal = sram_16bit_512k_0_avalon_slave_0_begins_xfer;

  //sram_16bit_512k_0_avalon_slave_0_arbitration_holdoff_internal arbitration_holdoff, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_arbitration_holdoff_internal = sram_16bit_512k_0_avalon_slave_0_begins_xfer & sram_16bit_512k_0_avalon_slave_0_firsttransfer;

  //~sram_16bit_512k_0_avalon_slave_0_read_n assignment, which is an e_mux
  assign sram_16bit_512k_0_avalon_slave_0_read_n = ~(((cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0 & cpu_data_master_read) | (cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0 & cpu_instruction_master_read))& ~sram_16bit_512k_0_avalon_slave_0_begins_xfer);

  //~sram_16bit_512k_0_avalon_slave_0_write_n assignment, which is an e_mux
  assign sram_16bit_512k_0_avalon_slave_0_write_n = ~(((cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0 & cpu_data_master_write)) & ~sram_16bit_512k_0_avalon_slave_0_begins_xfer & (sram_16bit_512k_0_avalon_slave_0_wait_counter >= 1));

  assign shifted_address_to_sram_16bit_512k_0_avalon_slave_0_from_cpu_data_master = {cpu_data_master_address_to_slave >> 2,
    cpu_data_master_dbs_address[1],
    {1 {1'b0}}};

  //sram_16bit_512k_0_avalon_slave_0_address mux, which is an e_mux
  assign sram_16bit_512k_0_avalon_slave_0_address = (cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0)? (shifted_address_to_sram_16bit_512k_0_avalon_slave_0_from_cpu_data_master >> 1) :
    (shifted_address_to_sram_16bit_512k_0_avalon_slave_0_from_cpu_instruction_master >> 1);

  assign shifted_address_to_sram_16bit_512k_0_avalon_slave_0_from_cpu_instruction_master = {cpu_instruction_master_address_to_slave >> 2,
    cpu_instruction_master_dbs_address[1],
    {1 {1'b0}}};

  //d1_sram_16bit_512k_0_avalon_slave_0_end_xfer register, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          d1_sram_16bit_512k_0_avalon_slave_0_end_xfer <= 1;
      else 
        d1_sram_16bit_512k_0_avalon_slave_0_end_xfer <= sram_16bit_512k_0_avalon_slave_0_end_xfer;
    end


  //sram_16bit_512k_0_avalon_slave_0_waits_for_read in a cycle, which is an e_mux
  assign sram_16bit_512k_0_avalon_slave_0_waits_for_read = sram_16bit_512k_0_avalon_slave_0_in_a_read_cycle & sram_16bit_512k_0_avalon_slave_0_begins_xfer;

  //sram_16bit_512k_0_avalon_slave_0_in_a_read_cycle assignment, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_in_a_read_cycle = (cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0 & cpu_data_master_read) | (cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0 & cpu_instruction_master_read);

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = sram_16bit_512k_0_avalon_slave_0_in_a_read_cycle;

  //sram_16bit_512k_0_avalon_slave_0_waits_for_write in a cycle, which is an e_mux
  assign sram_16bit_512k_0_avalon_slave_0_waits_for_write = sram_16bit_512k_0_avalon_slave_0_in_a_write_cycle & wait_for_sram_16bit_512k_0_avalon_slave_0_counter;

  //sram_16bit_512k_0_avalon_slave_0_in_a_write_cycle assignment, which is an e_assign
  assign sram_16bit_512k_0_avalon_slave_0_in_a_write_cycle = cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0 & cpu_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = sram_16bit_512k_0_avalon_slave_0_in_a_write_cycle;

  assign sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0 = sram_16bit_512k_0_avalon_slave_0_wait_counter == 0;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          sram_16bit_512k_0_avalon_slave_0_wait_counter <= 0;
      else 
        sram_16bit_512k_0_avalon_slave_0_wait_counter <= sram_16bit_512k_0_avalon_slave_0_counter_load_value;
    end


  assign sram_16bit_512k_0_avalon_slave_0_counter_load_value = ((sram_16bit_512k_0_avalon_slave_0_in_a_write_cycle & sram_16bit_512k_0_avalon_slave_0_begins_xfer))? 1 :
    (~sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0)? sram_16bit_512k_0_avalon_slave_0_wait_counter - 1 :
    0;

  assign wait_for_sram_16bit_512k_0_avalon_slave_0_counter = sram_16bit_512k_0_avalon_slave_0_begins_xfer | ~sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0;
  //~sram_16bit_512k_0_avalon_slave_0_byteenable_n byte enable port mux, which is an e_mux
  assign sram_16bit_512k_0_avalon_slave_0_byteenable_n = ~((cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0)? cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0 :
    -1);

  assign {cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0_segment_1,
cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0_segment_0} = cpu_data_master_byteenable;
  assign cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0 = ((cpu_data_master_dbs_address[1] == 0))? cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0_segment_0 :
    cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0_segment_1;


//synthesis translate_off
//////////////// SIMULATION-ONLY CONTENTS
  //sram_16bit_512k_0/avalon_slave_0 enable non-zero assertions, which is an e_register
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          enable_nonzero_assertions <= 0;
      else 
        enable_nonzero_assertions <= 1'b1;
    end


  //grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0 + cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0 > 1)
        begin
          $write("%0d ns: > 1 of grant signals are active simultaneously", $time);
          $stop;
        end
    end


  //saved_grant signals are active simultaneously, which is an e_process
  always @(posedge clk)
    begin
      if (cpu_data_master_saved_grant_sram_16bit_512k_0_avalon_slave_0 + cpu_instruction_master_saved_grant_sram_16bit_512k_0_avalon_slave_0 > 1)
        begin
          $write("%0d ns: > 1 of saved_grant signals are active simultaneously", $time);
          $stop;
        end
    end



//////////////// END SIMULATION-ONLY CONTENTS

//synthesis translate_on

endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module hope_reset_clk_domain_synch_module (
                                            // inputs:
                                             clk,
                                             data_in,
                                             reset_n,

                                            // outputs:
                                             data_out
                                          )
;

  output           data_out;
  input            clk;
  input            data_in;
  input            reset_n;

  reg              data_in_d1 /* synthesis ALTERA_ATTRIBUTE = "{-from \"*\"} CUT=ON ; PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101"  */;
  reg              data_out /* synthesis ALTERA_ATTRIBUTE = "PRESERVE_REGISTER=ON ; SUPPRESS_DA_RULE_INTERNAL=R101"  */;
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          data_in_d1 <= 0;
      else 
        data_in_d1 <= data_in;
    end


  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          data_out <= 0;
      else 
        data_out <= data_in_d1;
    end



endmodule


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// turn off superfluous verilog processor warnings 
// altera message_level Level1 
// altera message_off 10034 10035 10036 10037 10230 10240 10030 

module hope (
              // 1) global signals:
               clk,
               reset_n,

              // the_pio_hex
               out_port_from_the_pio_hex,

              // the_pio_key
               in_port_to_the_pio_key,

              // the_pio_left
               out_port_from_the_pio_left,

              // the_pio_pingpong
               out_port_from_the_pio_pingpong,

              // the_pio_right
               out_port_from_the_pio_right,

              // the_pio_sw
               in_port_to_the_pio_sw,

              // the_sram_16bit_512k_0
               SRAM_ADDR_from_the_sram_16bit_512k_0,
               SRAM_CE_N_from_the_sram_16bit_512k_0,
               SRAM_DQ_to_and_from_the_sram_16bit_512k_0,
               SRAM_LB_N_from_the_sram_16bit_512k_0,
               SRAM_OE_N_from_the_sram_16bit_512k_0,
               SRAM_UB_N_from_the_sram_16bit_512k_0,
               SRAM_WE_N_from_the_sram_16bit_512k_0
            )
;

  output  [ 17: 0] SRAM_ADDR_from_the_sram_16bit_512k_0;
  output           SRAM_CE_N_from_the_sram_16bit_512k_0;
  inout   [ 15: 0] SRAM_DQ_to_and_from_the_sram_16bit_512k_0;
  output           SRAM_LB_N_from_the_sram_16bit_512k_0;
  output           SRAM_OE_N_from_the_sram_16bit_512k_0;
  output           SRAM_UB_N_from_the_sram_16bit_512k_0;
  output           SRAM_WE_N_from_the_sram_16bit_512k_0;
  output  [ 15: 0] out_port_from_the_pio_hex;
  output  [ 31: 0] out_port_from_the_pio_left;
  output  [ 31: 0] out_port_from_the_pio_pingpong;
  output  [ 31: 0] out_port_from_the_pio_right;
  input            clk;
  input            in_port_to_the_pio_key;
  input   [ 31: 0] in_port_to_the_pio_sw;
  input            reset_n;

  wire    [ 17: 0] SRAM_ADDR_from_the_sram_16bit_512k_0;
  wire             SRAM_CE_N_from_the_sram_16bit_512k_0;
  wire    [ 15: 0] SRAM_DQ_to_and_from_the_sram_16bit_512k_0;
  wire             SRAM_LB_N_from_the_sram_16bit_512k_0;
  wire             SRAM_OE_N_from_the_sram_16bit_512k_0;
  wire             SRAM_UB_N_from_the_sram_16bit_512k_0;
  wire             SRAM_WE_N_from_the_sram_16bit_512k_0;
  wire             clk_reset_n;
  wire    [ 20: 0] cpu_data_master_address;
  wire    [ 20: 0] cpu_data_master_address_to_slave;
  wire    [  3: 0] cpu_data_master_byteenable;
  wire    [  1: 0] cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0;
  wire    [  1: 0] cpu_data_master_dbs_address;
  wire    [ 15: 0] cpu_data_master_dbs_write_16;
  wire             cpu_data_master_debugaccess;
  wire             cpu_data_master_granted_cpu_jtag_debug_module;
  wire             cpu_data_master_granted_pio_hex_s1;
  wire             cpu_data_master_granted_pio_key_s1;
  wire             cpu_data_master_granted_pio_left_s1;
  wire             cpu_data_master_granted_pio_pingpong_s1;
  wire             cpu_data_master_granted_pio_right_s1;
  wire             cpu_data_master_granted_pio_sw_s1;
  wire             cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0;
  wire    [ 31: 0] cpu_data_master_irq;
  wire             cpu_data_master_no_byte_enables_and_last_term;
  wire             cpu_data_master_qualified_request_cpu_jtag_debug_module;
  wire             cpu_data_master_qualified_request_pio_hex_s1;
  wire             cpu_data_master_qualified_request_pio_key_s1;
  wire             cpu_data_master_qualified_request_pio_left_s1;
  wire             cpu_data_master_qualified_request_pio_pingpong_s1;
  wire             cpu_data_master_qualified_request_pio_right_s1;
  wire             cpu_data_master_qualified_request_pio_sw_s1;
  wire             cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_data_master_read;
  wire             cpu_data_master_read_data_valid_cpu_jtag_debug_module;
  wire             cpu_data_master_read_data_valid_pio_hex_s1;
  wire             cpu_data_master_read_data_valid_pio_key_s1;
  wire             cpu_data_master_read_data_valid_pio_left_s1;
  wire             cpu_data_master_read_data_valid_pio_pingpong_s1;
  wire             cpu_data_master_read_data_valid_pio_right_s1;
  wire             cpu_data_master_read_data_valid_pio_sw_s1;
  wire             cpu_data_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0;
  wire    [ 31: 0] cpu_data_master_readdata;
  wire             cpu_data_master_requests_cpu_jtag_debug_module;
  wire             cpu_data_master_requests_pio_hex_s1;
  wire             cpu_data_master_requests_pio_key_s1;
  wire             cpu_data_master_requests_pio_left_s1;
  wire             cpu_data_master_requests_pio_pingpong_s1;
  wire             cpu_data_master_requests_pio_right_s1;
  wire             cpu_data_master_requests_pio_sw_s1;
  wire             cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_data_master_waitrequest;
  wire             cpu_data_master_write;
  wire    [ 31: 0] cpu_data_master_writedata;
  wire    [ 20: 0] cpu_instruction_master_address;
  wire    [ 20: 0] cpu_instruction_master_address_to_slave;
  wire    [  1: 0] cpu_instruction_master_dbs_address;
  wire             cpu_instruction_master_granted_cpu_jtag_debug_module;
  wire             cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_instruction_master_latency_counter;
  wire             cpu_instruction_master_qualified_request_cpu_jtag_debug_module;
  wire             cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_instruction_master_read;
  wire             cpu_instruction_master_read_data_valid_cpu_jtag_debug_module;
  wire             cpu_instruction_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0;
  wire    [ 31: 0] cpu_instruction_master_readdata;
  wire             cpu_instruction_master_readdatavalid;
  wire             cpu_instruction_master_requests_cpu_jtag_debug_module;
  wire             cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0;
  wire             cpu_instruction_master_waitrequest;
  wire    [  8: 0] cpu_jtag_debug_module_address;
  wire             cpu_jtag_debug_module_begintransfer;
  wire    [  3: 0] cpu_jtag_debug_module_byteenable;
  wire             cpu_jtag_debug_module_chipselect;
  wire             cpu_jtag_debug_module_debugaccess;
  wire    [ 31: 0] cpu_jtag_debug_module_readdata;
  wire    [ 31: 0] cpu_jtag_debug_module_readdata_from_sa;
  wire             cpu_jtag_debug_module_reset_n;
  wire             cpu_jtag_debug_module_resetrequest;
  wire             cpu_jtag_debug_module_resetrequest_from_sa;
  wire             cpu_jtag_debug_module_write;
  wire    [ 31: 0] cpu_jtag_debug_module_writedata;
  wire             d1_cpu_jtag_debug_module_end_xfer;
  wire             d1_pio_hex_s1_end_xfer;
  wire             d1_pio_key_s1_end_xfer;
  wire             d1_pio_left_s1_end_xfer;
  wire             d1_pio_pingpong_s1_end_xfer;
  wire             d1_pio_right_s1_end_xfer;
  wire             d1_pio_sw_s1_end_xfer;
  wire             d1_sram_16bit_512k_0_avalon_slave_0_end_xfer;
  wire    [ 15: 0] out_port_from_the_pio_hex;
  wire    [ 31: 0] out_port_from_the_pio_left;
  wire    [ 31: 0] out_port_from_the_pio_pingpong;
  wire    [ 31: 0] out_port_from_the_pio_right;
  wire    [  1: 0] pio_hex_s1_address;
  wire             pio_hex_s1_chipselect;
  wire    [ 31: 0] pio_hex_s1_readdata;
  wire    [ 31: 0] pio_hex_s1_readdata_from_sa;
  wire             pio_hex_s1_reset_n;
  wire             pio_hex_s1_write_n;
  wire    [ 31: 0] pio_hex_s1_writedata;
  wire    [  1: 0] pio_key_s1_address;
  wire             pio_key_s1_chipselect;
  wire             pio_key_s1_irq;
  wire             pio_key_s1_irq_from_sa;
  wire    [ 31: 0] pio_key_s1_readdata;
  wire    [ 31: 0] pio_key_s1_readdata_from_sa;
  wire             pio_key_s1_reset_n;
  wire             pio_key_s1_write_n;
  wire    [ 31: 0] pio_key_s1_writedata;
  wire    [  1: 0] pio_left_s1_address;
  wire             pio_left_s1_chipselect;
  wire    [ 31: 0] pio_left_s1_readdata;
  wire    [ 31: 0] pio_left_s1_readdata_from_sa;
  wire             pio_left_s1_reset_n;
  wire             pio_left_s1_write_n;
  wire    [ 31: 0] pio_left_s1_writedata;
  wire    [  1: 0] pio_pingpong_s1_address;
  wire             pio_pingpong_s1_chipselect;
  wire    [ 31: 0] pio_pingpong_s1_readdata;
  wire    [ 31: 0] pio_pingpong_s1_readdata_from_sa;
  wire             pio_pingpong_s1_reset_n;
  wire             pio_pingpong_s1_write_n;
  wire    [ 31: 0] pio_pingpong_s1_writedata;
  wire    [  1: 0] pio_right_s1_address;
  wire             pio_right_s1_chipselect;
  wire    [ 31: 0] pio_right_s1_readdata;
  wire    [ 31: 0] pio_right_s1_readdata_from_sa;
  wire             pio_right_s1_reset_n;
  wire             pio_right_s1_write_n;
  wire    [ 31: 0] pio_right_s1_writedata;
  wire    [  1: 0] pio_sw_s1_address;
  wire    [ 31: 0] pio_sw_s1_readdata;
  wire    [ 31: 0] pio_sw_s1_readdata_from_sa;
  wire             pio_sw_s1_reset_n;
  wire             reset_n_sources;
  wire    [ 17: 0] sram_16bit_512k_0_avalon_slave_0_address;
  wire    [  1: 0] sram_16bit_512k_0_avalon_slave_0_byteenable_n;
  wire             sram_16bit_512k_0_avalon_slave_0_chipselect_n;
  wire             sram_16bit_512k_0_avalon_slave_0_read_n;
  wire    [ 15: 0] sram_16bit_512k_0_avalon_slave_0_readdata;
  wire    [ 15: 0] sram_16bit_512k_0_avalon_slave_0_readdata_from_sa;
  wire             sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0;
  wire             sram_16bit_512k_0_avalon_slave_0_write_n;
  wire    [ 15: 0] sram_16bit_512k_0_avalon_slave_0_writedata;
  cpu_jtag_debug_module_arbitrator the_cpu_jtag_debug_module
    (
      .clk                                                            (clk),
      .cpu_data_master_address_to_slave                               (cpu_data_master_address_to_slave),
      .cpu_data_master_byteenable                                     (cpu_data_master_byteenable),
      .cpu_data_master_debugaccess                                    (cpu_data_master_debugaccess),
      .cpu_data_master_granted_cpu_jtag_debug_module                  (cpu_data_master_granted_cpu_jtag_debug_module),
      .cpu_data_master_qualified_request_cpu_jtag_debug_module        (cpu_data_master_qualified_request_cpu_jtag_debug_module),
      .cpu_data_master_read                                           (cpu_data_master_read),
      .cpu_data_master_read_data_valid_cpu_jtag_debug_module          (cpu_data_master_read_data_valid_cpu_jtag_debug_module),
      .cpu_data_master_requests_cpu_jtag_debug_module                 (cpu_data_master_requests_cpu_jtag_debug_module),
      .cpu_data_master_waitrequest                                    (cpu_data_master_waitrequest),
      .cpu_data_master_write                                          (cpu_data_master_write),
      .cpu_data_master_writedata                                      (cpu_data_master_writedata),
      .cpu_instruction_master_address_to_slave                        (cpu_instruction_master_address_to_slave),
      .cpu_instruction_master_granted_cpu_jtag_debug_module           (cpu_instruction_master_granted_cpu_jtag_debug_module),
      .cpu_instruction_master_latency_counter                         (cpu_instruction_master_latency_counter),
      .cpu_instruction_master_qualified_request_cpu_jtag_debug_module (cpu_instruction_master_qualified_request_cpu_jtag_debug_module),
      .cpu_instruction_master_read                                    (cpu_instruction_master_read),
      .cpu_instruction_master_read_data_valid_cpu_jtag_debug_module   (cpu_instruction_master_read_data_valid_cpu_jtag_debug_module),
      .cpu_instruction_master_requests_cpu_jtag_debug_module          (cpu_instruction_master_requests_cpu_jtag_debug_module),
      .cpu_jtag_debug_module_address                                  (cpu_jtag_debug_module_address),
      .cpu_jtag_debug_module_begintransfer                            (cpu_jtag_debug_module_begintransfer),
      .cpu_jtag_debug_module_byteenable                               (cpu_jtag_debug_module_byteenable),
      .cpu_jtag_debug_module_chipselect                               (cpu_jtag_debug_module_chipselect),
      .cpu_jtag_debug_module_debugaccess                              (cpu_jtag_debug_module_debugaccess),
      .cpu_jtag_debug_module_readdata                                 (cpu_jtag_debug_module_readdata),
      .cpu_jtag_debug_module_readdata_from_sa                         (cpu_jtag_debug_module_readdata_from_sa),
      .cpu_jtag_debug_module_reset_n                                  (cpu_jtag_debug_module_reset_n),
      .cpu_jtag_debug_module_resetrequest                             (cpu_jtag_debug_module_resetrequest),
      .cpu_jtag_debug_module_resetrequest_from_sa                     (cpu_jtag_debug_module_resetrequest_from_sa),
      .cpu_jtag_debug_module_write                                    (cpu_jtag_debug_module_write),
      .cpu_jtag_debug_module_writedata                                (cpu_jtag_debug_module_writedata),
      .d1_cpu_jtag_debug_module_end_xfer                              (d1_cpu_jtag_debug_module_end_xfer),
      .reset_n                                                        (clk_reset_n)
    );

  cpu_data_master_arbitrator the_cpu_data_master
    (
      .clk                                                                (clk),
      .cpu_data_master_address                                            (cpu_data_master_address),
      .cpu_data_master_address_to_slave                                   (cpu_data_master_address_to_slave),
      .cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0        (cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0),
      .cpu_data_master_dbs_address                                        (cpu_data_master_dbs_address),
      .cpu_data_master_dbs_write_16                                       (cpu_data_master_dbs_write_16),
      .cpu_data_master_granted_cpu_jtag_debug_module                      (cpu_data_master_granted_cpu_jtag_debug_module),
      .cpu_data_master_granted_pio_hex_s1                                 (cpu_data_master_granted_pio_hex_s1),
      .cpu_data_master_granted_pio_key_s1                                 (cpu_data_master_granted_pio_key_s1),
      .cpu_data_master_granted_pio_left_s1                                (cpu_data_master_granted_pio_left_s1),
      .cpu_data_master_granted_pio_pingpong_s1                            (cpu_data_master_granted_pio_pingpong_s1),
      .cpu_data_master_granted_pio_right_s1                               (cpu_data_master_granted_pio_right_s1),
      .cpu_data_master_granted_pio_sw_s1                                  (cpu_data_master_granted_pio_sw_s1),
      .cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0           (cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0),
      .cpu_data_master_irq                                                (cpu_data_master_irq),
      .cpu_data_master_no_byte_enables_and_last_term                      (cpu_data_master_no_byte_enables_and_last_term),
      .cpu_data_master_qualified_request_cpu_jtag_debug_module            (cpu_data_master_qualified_request_cpu_jtag_debug_module),
      .cpu_data_master_qualified_request_pio_hex_s1                       (cpu_data_master_qualified_request_pio_hex_s1),
      .cpu_data_master_qualified_request_pio_key_s1                       (cpu_data_master_qualified_request_pio_key_s1),
      .cpu_data_master_qualified_request_pio_left_s1                      (cpu_data_master_qualified_request_pio_left_s1),
      .cpu_data_master_qualified_request_pio_pingpong_s1                  (cpu_data_master_qualified_request_pio_pingpong_s1),
      .cpu_data_master_qualified_request_pio_right_s1                     (cpu_data_master_qualified_request_pio_right_s1),
      .cpu_data_master_qualified_request_pio_sw_s1                        (cpu_data_master_qualified_request_pio_sw_s1),
      .cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0 (cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0),
      .cpu_data_master_read                                               (cpu_data_master_read),
      .cpu_data_master_read_data_valid_cpu_jtag_debug_module              (cpu_data_master_read_data_valid_cpu_jtag_debug_module),
      .cpu_data_master_read_data_valid_pio_hex_s1                         (cpu_data_master_read_data_valid_pio_hex_s1),
      .cpu_data_master_read_data_valid_pio_key_s1                         (cpu_data_master_read_data_valid_pio_key_s1),
      .cpu_data_master_read_data_valid_pio_left_s1                        (cpu_data_master_read_data_valid_pio_left_s1),
      .cpu_data_master_read_data_valid_pio_pingpong_s1                    (cpu_data_master_read_data_valid_pio_pingpong_s1),
      .cpu_data_master_read_data_valid_pio_right_s1                       (cpu_data_master_read_data_valid_pio_right_s1),
      .cpu_data_master_read_data_valid_pio_sw_s1                          (cpu_data_master_read_data_valid_pio_sw_s1),
      .cpu_data_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0   (cpu_data_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0),
      .cpu_data_master_readdata                                           (cpu_data_master_readdata),
      .cpu_data_master_requests_cpu_jtag_debug_module                     (cpu_data_master_requests_cpu_jtag_debug_module),
      .cpu_data_master_requests_pio_hex_s1                                (cpu_data_master_requests_pio_hex_s1),
      .cpu_data_master_requests_pio_key_s1                                (cpu_data_master_requests_pio_key_s1),
      .cpu_data_master_requests_pio_left_s1                               (cpu_data_master_requests_pio_left_s1),
      .cpu_data_master_requests_pio_pingpong_s1                           (cpu_data_master_requests_pio_pingpong_s1),
      .cpu_data_master_requests_pio_right_s1                              (cpu_data_master_requests_pio_right_s1),
      .cpu_data_master_requests_pio_sw_s1                                 (cpu_data_master_requests_pio_sw_s1),
      .cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0          (cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0),
      .cpu_data_master_waitrequest                                        (cpu_data_master_waitrequest),
      .cpu_data_master_write                                              (cpu_data_master_write),
      .cpu_data_master_writedata                                          (cpu_data_master_writedata),
      .cpu_jtag_debug_module_readdata_from_sa                             (cpu_jtag_debug_module_readdata_from_sa),
      .d1_cpu_jtag_debug_module_end_xfer                                  (d1_cpu_jtag_debug_module_end_xfer),
      .d1_pio_hex_s1_end_xfer                                             (d1_pio_hex_s1_end_xfer),
      .d1_pio_key_s1_end_xfer                                             (d1_pio_key_s1_end_xfer),
      .d1_pio_left_s1_end_xfer                                            (d1_pio_left_s1_end_xfer),
      .d1_pio_pingpong_s1_end_xfer                                        (d1_pio_pingpong_s1_end_xfer),
      .d1_pio_right_s1_end_xfer                                           (d1_pio_right_s1_end_xfer),
      .d1_pio_sw_s1_end_xfer                                              (d1_pio_sw_s1_end_xfer),
      .d1_sram_16bit_512k_0_avalon_slave_0_end_xfer                       (d1_sram_16bit_512k_0_avalon_slave_0_end_xfer),
      .pio_hex_s1_readdata_from_sa                                        (pio_hex_s1_readdata_from_sa),
      .pio_key_s1_irq_from_sa                                             (pio_key_s1_irq_from_sa),
      .pio_key_s1_readdata_from_sa                                        (pio_key_s1_readdata_from_sa),
      .pio_left_s1_readdata_from_sa                                       (pio_left_s1_readdata_from_sa),
      .pio_pingpong_s1_readdata_from_sa                                   (pio_pingpong_s1_readdata_from_sa),
      .pio_right_s1_readdata_from_sa                                      (pio_right_s1_readdata_from_sa),
      .pio_sw_s1_readdata_from_sa                                         (pio_sw_s1_readdata_from_sa),
      .reset_n                                                            (clk_reset_n),
      .sram_16bit_512k_0_avalon_slave_0_readdata_from_sa                  (sram_16bit_512k_0_avalon_slave_0_readdata_from_sa),
      .sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0                 (sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0)
    );

  cpu_instruction_master_arbitrator the_cpu_instruction_master
    (
      .clk                                                                       (clk),
      .cpu_instruction_master_address                                            (cpu_instruction_master_address),
      .cpu_instruction_master_address_to_slave                                   (cpu_instruction_master_address_to_slave),
      .cpu_instruction_master_dbs_address                                        (cpu_instruction_master_dbs_address),
      .cpu_instruction_master_granted_cpu_jtag_debug_module                      (cpu_instruction_master_granted_cpu_jtag_debug_module),
      .cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0           (cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0),
      .cpu_instruction_master_latency_counter                                    (cpu_instruction_master_latency_counter),
      .cpu_instruction_master_qualified_request_cpu_jtag_debug_module            (cpu_instruction_master_qualified_request_cpu_jtag_debug_module),
      .cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0 (cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0),
      .cpu_instruction_master_read                                               (cpu_instruction_master_read),
      .cpu_instruction_master_read_data_valid_cpu_jtag_debug_module              (cpu_instruction_master_read_data_valid_cpu_jtag_debug_module),
      .cpu_instruction_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0   (cpu_instruction_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0),
      .cpu_instruction_master_readdata                                           (cpu_instruction_master_readdata),
      .cpu_instruction_master_readdatavalid                                      (cpu_instruction_master_readdatavalid),
      .cpu_instruction_master_requests_cpu_jtag_debug_module                     (cpu_instruction_master_requests_cpu_jtag_debug_module),
      .cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0          (cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0),
      .cpu_instruction_master_waitrequest                                        (cpu_instruction_master_waitrequest),
      .cpu_jtag_debug_module_readdata_from_sa                                    (cpu_jtag_debug_module_readdata_from_sa),
      .d1_cpu_jtag_debug_module_end_xfer                                         (d1_cpu_jtag_debug_module_end_xfer),
      .d1_sram_16bit_512k_0_avalon_slave_0_end_xfer                              (d1_sram_16bit_512k_0_avalon_slave_0_end_xfer),
      .reset_n                                                                   (clk_reset_n),
      .sram_16bit_512k_0_avalon_slave_0_readdata_from_sa                         (sram_16bit_512k_0_avalon_slave_0_readdata_from_sa),
      .sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0                        (sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0)
    );

  cpu the_cpu
    (
      .clk                                   (clk),
      .d_address                             (cpu_data_master_address),
      .d_byteenable                          (cpu_data_master_byteenable),
      .d_irq                                 (cpu_data_master_irq),
      .d_read                                (cpu_data_master_read),
      .d_readdata                            (cpu_data_master_readdata),
      .d_waitrequest                         (cpu_data_master_waitrequest),
      .d_write                               (cpu_data_master_write),
      .d_writedata                           (cpu_data_master_writedata),
      .i_address                             (cpu_instruction_master_address),
      .i_read                                (cpu_instruction_master_read),
      .i_readdata                            (cpu_instruction_master_readdata),
      .i_readdatavalid                       (cpu_instruction_master_readdatavalid),
      .i_waitrequest                         (cpu_instruction_master_waitrequest),
      .jtag_debug_module_address             (cpu_jtag_debug_module_address),
      .jtag_debug_module_begintransfer       (cpu_jtag_debug_module_begintransfer),
      .jtag_debug_module_byteenable          (cpu_jtag_debug_module_byteenable),
      .jtag_debug_module_debugaccess         (cpu_jtag_debug_module_debugaccess),
      .jtag_debug_module_debugaccess_to_roms (cpu_data_master_debugaccess),
      .jtag_debug_module_readdata            (cpu_jtag_debug_module_readdata),
      .jtag_debug_module_resetrequest        (cpu_jtag_debug_module_resetrequest),
      .jtag_debug_module_select              (cpu_jtag_debug_module_chipselect),
      .jtag_debug_module_write               (cpu_jtag_debug_module_write),
      .jtag_debug_module_writedata           (cpu_jtag_debug_module_writedata),
      .reset_n                               (cpu_jtag_debug_module_reset_n)
    );

  pio_hex_s1_arbitrator the_pio_hex_s1
    (
      .clk                                          (clk),
      .cpu_data_master_address_to_slave             (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_pio_hex_s1           (cpu_data_master_granted_pio_hex_s1),
      .cpu_data_master_qualified_request_pio_hex_s1 (cpu_data_master_qualified_request_pio_hex_s1),
      .cpu_data_master_read                         (cpu_data_master_read),
      .cpu_data_master_read_data_valid_pio_hex_s1   (cpu_data_master_read_data_valid_pio_hex_s1),
      .cpu_data_master_requests_pio_hex_s1          (cpu_data_master_requests_pio_hex_s1),
      .cpu_data_master_waitrequest                  (cpu_data_master_waitrequest),
      .cpu_data_master_write                        (cpu_data_master_write),
      .cpu_data_master_writedata                    (cpu_data_master_writedata),
      .d1_pio_hex_s1_end_xfer                       (d1_pio_hex_s1_end_xfer),
      .pio_hex_s1_address                           (pio_hex_s1_address),
      .pio_hex_s1_chipselect                        (pio_hex_s1_chipselect),
      .pio_hex_s1_readdata                          (pio_hex_s1_readdata),
      .pio_hex_s1_readdata_from_sa                  (pio_hex_s1_readdata_from_sa),
      .pio_hex_s1_reset_n                           (pio_hex_s1_reset_n),
      .pio_hex_s1_write_n                           (pio_hex_s1_write_n),
      .pio_hex_s1_writedata                         (pio_hex_s1_writedata),
      .reset_n                                      (clk_reset_n)
    );

  pio_hex the_pio_hex
    (
      .address    (pio_hex_s1_address),
      .chipselect (pio_hex_s1_chipselect),
      .clk        (clk),
      .out_port   (out_port_from_the_pio_hex),
      .readdata   (pio_hex_s1_readdata),
      .reset_n    (pio_hex_s1_reset_n),
      .write_n    (pio_hex_s1_write_n),
      .writedata  (pio_hex_s1_writedata)
    );

  pio_key_s1_arbitrator the_pio_key_s1
    (
      .clk                                          (clk),
      .cpu_data_master_address_to_slave             (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_pio_key_s1           (cpu_data_master_granted_pio_key_s1),
      .cpu_data_master_qualified_request_pio_key_s1 (cpu_data_master_qualified_request_pio_key_s1),
      .cpu_data_master_read                         (cpu_data_master_read),
      .cpu_data_master_read_data_valid_pio_key_s1   (cpu_data_master_read_data_valid_pio_key_s1),
      .cpu_data_master_requests_pio_key_s1          (cpu_data_master_requests_pio_key_s1),
      .cpu_data_master_waitrequest                  (cpu_data_master_waitrequest),
      .cpu_data_master_write                        (cpu_data_master_write),
      .cpu_data_master_writedata                    (cpu_data_master_writedata),
      .d1_pio_key_s1_end_xfer                       (d1_pio_key_s1_end_xfer),
      .pio_key_s1_address                           (pio_key_s1_address),
      .pio_key_s1_chipselect                        (pio_key_s1_chipselect),
      .pio_key_s1_irq                               (pio_key_s1_irq),
      .pio_key_s1_irq_from_sa                       (pio_key_s1_irq_from_sa),
      .pio_key_s1_readdata                          (pio_key_s1_readdata),
      .pio_key_s1_readdata_from_sa                  (pio_key_s1_readdata_from_sa),
      .pio_key_s1_reset_n                           (pio_key_s1_reset_n),
      .pio_key_s1_write_n                           (pio_key_s1_write_n),
      .pio_key_s1_writedata                         (pio_key_s1_writedata),
      .reset_n                                      (clk_reset_n)
    );

  pio_key the_pio_key
    (
      .address    (pio_key_s1_address),
      .chipselect (pio_key_s1_chipselect),
      .clk        (clk),
      .in_port    (in_port_to_the_pio_key),
      .irq        (pio_key_s1_irq),
      .readdata   (pio_key_s1_readdata),
      .reset_n    (pio_key_s1_reset_n),
      .write_n    (pio_key_s1_write_n),
      .writedata  (pio_key_s1_writedata)
    );

  pio_left_s1_arbitrator the_pio_left_s1
    (
      .clk                                           (clk),
      .cpu_data_master_address_to_slave              (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_pio_left_s1           (cpu_data_master_granted_pio_left_s1),
      .cpu_data_master_qualified_request_pio_left_s1 (cpu_data_master_qualified_request_pio_left_s1),
      .cpu_data_master_read                          (cpu_data_master_read),
      .cpu_data_master_read_data_valid_pio_left_s1   (cpu_data_master_read_data_valid_pio_left_s1),
      .cpu_data_master_requests_pio_left_s1          (cpu_data_master_requests_pio_left_s1),
      .cpu_data_master_waitrequest                   (cpu_data_master_waitrequest),
      .cpu_data_master_write                         (cpu_data_master_write),
      .cpu_data_master_writedata                     (cpu_data_master_writedata),
      .d1_pio_left_s1_end_xfer                       (d1_pio_left_s1_end_xfer),
      .pio_left_s1_address                           (pio_left_s1_address),
      .pio_left_s1_chipselect                        (pio_left_s1_chipselect),
      .pio_left_s1_readdata                          (pio_left_s1_readdata),
      .pio_left_s1_readdata_from_sa                  (pio_left_s1_readdata_from_sa),
      .pio_left_s1_reset_n                           (pio_left_s1_reset_n),
      .pio_left_s1_write_n                           (pio_left_s1_write_n),
      .pio_left_s1_writedata                         (pio_left_s1_writedata),
      .reset_n                                       (clk_reset_n)
    );

  pio_left the_pio_left
    (
      .address    (pio_left_s1_address),
      .chipselect (pio_left_s1_chipselect),
      .clk        (clk),
      .out_port   (out_port_from_the_pio_left),
      .readdata   (pio_left_s1_readdata),
      .reset_n    (pio_left_s1_reset_n),
      .write_n    (pio_left_s1_write_n),
      .writedata  (pio_left_s1_writedata)
    );

  pio_pingpong_s1_arbitrator the_pio_pingpong_s1
    (
      .clk                                               (clk),
      .cpu_data_master_address_to_slave                  (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_pio_pingpong_s1           (cpu_data_master_granted_pio_pingpong_s1),
      .cpu_data_master_qualified_request_pio_pingpong_s1 (cpu_data_master_qualified_request_pio_pingpong_s1),
      .cpu_data_master_read                              (cpu_data_master_read),
      .cpu_data_master_read_data_valid_pio_pingpong_s1   (cpu_data_master_read_data_valid_pio_pingpong_s1),
      .cpu_data_master_requests_pio_pingpong_s1          (cpu_data_master_requests_pio_pingpong_s1),
      .cpu_data_master_waitrequest                       (cpu_data_master_waitrequest),
      .cpu_data_master_write                             (cpu_data_master_write),
      .cpu_data_master_writedata                         (cpu_data_master_writedata),
      .d1_pio_pingpong_s1_end_xfer                       (d1_pio_pingpong_s1_end_xfer),
      .pio_pingpong_s1_address                           (pio_pingpong_s1_address),
      .pio_pingpong_s1_chipselect                        (pio_pingpong_s1_chipselect),
      .pio_pingpong_s1_readdata                          (pio_pingpong_s1_readdata),
      .pio_pingpong_s1_readdata_from_sa                  (pio_pingpong_s1_readdata_from_sa),
      .pio_pingpong_s1_reset_n                           (pio_pingpong_s1_reset_n),
      .pio_pingpong_s1_write_n                           (pio_pingpong_s1_write_n),
      .pio_pingpong_s1_writedata                         (pio_pingpong_s1_writedata),
      .reset_n                                           (clk_reset_n)
    );

  pio_pingpong the_pio_pingpong
    (
      .address    (pio_pingpong_s1_address),
      .chipselect (pio_pingpong_s1_chipselect),
      .clk        (clk),
      .out_port   (out_port_from_the_pio_pingpong),
      .readdata   (pio_pingpong_s1_readdata),
      .reset_n    (pio_pingpong_s1_reset_n),
      .write_n    (pio_pingpong_s1_write_n),
      .writedata  (pio_pingpong_s1_writedata)
    );

  pio_right_s1_arbitrator the_pio_right_s1
    (
      .clk                                            (clk),
      .cpu_data_master_address_to_slave               (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_pio_right_s1           (cpu_data_master_granted_pio_right_s1),
      .cpu_data_master_qualified_request_pio_right_s1 (cpu_data_master_qualified_request_pio_right_s1),
      .cpu_data_master_read                           (cpu_data_master_read),
      .cpu_data_master_read_data_valid_pio_right_s1   (cpu_data_master_read_data_valid_pio_right_s1),
      .cpu_data_master_requests_pio_right_s1          (cpu_data_master_requests_pio_right_s1),
      .cpu_data_master_waitrequest                    (cpu_data_master_waitrequest),
      .cpu_data_master_write                          (cpu_data_master_write),
      .cpu_data_master_writedata                      (cpu_data_master_writedata),
      .d1_pio_right_s1_end_xfer                       (d1_pio_right_s1_end_xfer),
      .pio_right_s1_address                           (pio_right_s1_address),
      .pio_right_s1_chipselect                        (pio_right_s1_chipselect),
      .pio_right_s1_readdata                          (pio_right_s1_readdata),
      .pio_right_s1_readdata_from_sa                  (pio_right_s1_readdata_from_sa),
      .pio_right_s1_reset_n                           (pio_right_s1_reset_n),
      .pio_right_s1_write_n                           (pio_right_s1_write_n),
      .pio_right_s1_writedata                         (pio_right_s1_writedata),
      .reset_n                                        (clk_reset_n)
    );

  pio_right the_pio_right
    (
      .address    (pio_right_s1_address),
      .chipselect (pio_right_s1_chipselect),
      .clk        (clk),
      .out_port   (out_port_from_the_pio_right),
      .readdata   (pio_right_s1_readdata),
      .reset_n    (pio_right_s1_reset_n),
      .write_n    (pio_right_s1_write_n),
      .writedata  (pio_right_s1_writedata)
    );

  pio_sw_s1_arbitrator the_pio_sw_s1
    (
      .clk                                         (clk),
      .cpu_data_master_address_to_slave            (cpu_data_master_address_to_slave),
      .cpu_data_master_granted_pio_sw_s1           (cpu_data_master_granted_pio_sw_s1),
      .cpu_data_master_qualified_request_pio_sw_s1 (cpu_data_master_qualified_request_pio_sw_s1),
      .cpu_data_master_read                        (cpu_data_master_read),
      .cpu_data_master_read_data_valid_pio_sw_s1   (cpu_data_master_read_data_valid_pio_sw_s1),
      .cpu_data_master_requests_pio_sw_s1          (cpu_data_master_requests_pio_sw_s1),
      .cpu_data_master_write                       (cpu_data_master_write),
      .d1_pio_sw_s1_end_xfer                       (d1_pio_sw_s1_end_xfer),
      .pio_sw_s1_address                           (pio_sw_s1_address),
      .pio_sw_s1_readdata                          (pio_sw_s1_readdata),
      .pio_sw_s1_readdata_from_sa                  (pio_sw_s1_readdata_from_sa),
      .pio_sw_s1_reset_n                           (pio_sw_s1_reset_n),
      .reset_n                                     (clk_reset_n)
    );

  pio_sw the_pio_sw
    (
      .address  (pio_sw_s1_address),
      .clk      (clk),
      .in_port  (in_port_to_the_pio_sw),
      .readdata (pio_sw_s1_readdata),
      .reset_n  (pio_sw_s1_reset_n)
    );

  sram_16bit_512k_0_avalon_slave_0_arbitrator the_sram_16bit_512k_0_avalon_slave_0
    (
      .clk                                                                       (clk),
      .cpu_data_master_address_to_slave                                          (cpu_data_master_address_to_slave),
      .cpu_data_master_byteenable                                                (cpu_data_master_byteenable),
      .cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0               (cpu_data_master_byteenable_sram_16bit_512k_0_avalon_slave_0),
      .cpu_data_master_dbs_address                                               (cpu_data_master_dbs_address),
      .cpu_data_master_dbs_write_16                                              (cpu_data_master_dbs_write_16),
      .cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0                  (cpu_data_master_granted_sram_16bit_512k_0_avalon_slave_0),
      .cpu_data_master_no_byte_enables_and_last_term                             (cpu_data_master_no_byte_enables_and_last_term),
      .cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0        (cpu_data_master_qualified_request_sram_16bit_512k_0_avalon_slave_0),
      .cpu_data_master_read                                                      (cpu_data_master_read),
      .cpu_data_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0          (cpu_data_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0),
      .cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0                 (cpu_data_master_requests_sram_16bit_512k_0_avalon_slave_0),
      .cpu_data_master_write                                                     (cpu_data_master_write),
      .cpu_instruction_master_address_to_slave                                   (cpu_instruction_master_address_to_slave),
      .cpu_instruction_master_dbs_address                                        (cpu_instruction_master_dbs_address),
      .cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0           (cpu_instruction_master_granted_sram_16bit_512k_0_avalon_slave_0),
      .cpu_instruction_master_latency_counter                                    (cpu_instruction_master_latency_counter),
      .cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0 (cpu_instruction_master_qualified_request_sram_16bit_512k_0_avalon_slave_0),
      .cpu_instruction_master_read                                               (cpu_instruction_master_read),
      .cpu_instruction_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0   (cpu_instruction_master_read_data_valid_sram_16bit_512k_0_avalon_slave_0),
      .cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0          (cpu_instruction_master_requests_sram_16bit_512k_0_avalon_slave_0),
      .d1_sram_16bit_512k_0_avalon_slave_0_end_xfer                              (d1_sram_16bit_512k_0_avalon_slave_0_end_xfer),
      .reset_n                                                                   (clk_reset_n),
      .sram_16bit_512k_0_avalon_slave_0_address                                  (sram_16bit_512k_0_avalon_slave_0_address),
      .sram_16bit_512k_0_avalon_slave_0_byteenable_n                             (sram_16bit_512k_0_avalon_slave_0_byteenable_n),
      .sram_16bit_512k_0_avalon_slave_0_chipselect_n                             (sram_16bit_512k_0_avalon_slave_0_chipselect_n),
      .sram_16bit_512k_0_avalon_slave_0_read_n                                   (sram_16bit_512k_0_avalon_slave_0_read_n),
      .sram_16bit_512k_0_avalon_slave_0_readdata                                 (sram_16bit_512k_0_avalon_slave_0_readdata),
      .sram_16bit_512k_0_avalon_slave_0_readdata_from_sa                         (sram_16bit_512k_0_avalon_slave_0_readdata_from_sa),
      .sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0                        (sram_16bit_512k_0_avalon_slave_0_wait_counter_eq_0),
      .sram_16bit_512k_0_avalon_slave_0_write_n                                  (sram_16bit_512k_0_avalon_slave_0_write_n),
      .sram_16bit_512k_0_avalon_slave_0_writedata                                (sram_16bit_512k_0_avalon_slave_0_writedata)
    );

  sram_16bit_512k_0 the_sram_16bit_512k_0
    (
      .SRAM_ADDR (SRAM_ADDR_from_the_sram_16bit_512k_0),
      .SRAM_CE_N (SRAM_CE_N_from_the_sram_16bit_512k_0),
      .SRAM_DQ   (SRAM_DQ_to_and_from_the_sram_16bit_512k_0),
      .SRAM_LB_N (SRAM_LB_N_from_the_sram_16bit_512k_0),
      .SRAM_OE_N (SRAM_OE_N_from_the_sram_16bit_512k_0),
      .SRAM_UB_N (SRAM_UB_N_from_the_sram_16bit_512k_0),
      .SRAM_WE_N (SRAM_WE_N_from_the_sram_16bit_512k_0),
      .iADDR     (sram_16bit_512k_0_avalon_slave_0_address),
      .iBE_N     (sram_16bit_512k_0_avalon_slave_0_byteenable_n),
      .iCE_N     (sram_16bit_512k_0_avalon_slave_0_chipselect_n),
      .iCLK      (clk),
      .iDATA     (sram_16bit_512k_0_avalon_slave_0_writedata),
      .iOE_N     (sram_16bit_512k_0_avalon_slave_0_read_n),
      .iWE_N     (sram_16bit_512k_0_avalon_slave_0_write_n),
      .oDATA     (sram_16bit_512k_0_avalon_slave_0_readdata)
    );

  //reset is asserted asynchronously and deasserted synchronously
  hope_reset_clk_domain_synch_module hope_reset_clk_domain_synch
    (
      .clk      (clk),
      .data_in  (1'b1),
      .data_out (clk_reset_n),
      .reset_n  (reset_n_sources)
    );

  //reset sources mux, which is an e_mux
  assign reset_n_sources = ~(~reset_n |
    0 |
    cpu_jtag_debug_module_resetrequest_from_sa |
    cpu_jtag_debug_module_resetrequest_from_sa);


endmodule


//synthesis translate_off



// <ALTERA_NOTE> CODE INSERTED BETWEEN HERE

// AND HERE WILL BE PRESERVED </ALTERA_NOTE>


// If user logic components use Altsync_Ram with convert_hex2ver.dll,
// set USE_convert_hex2ver in the user comments section above

// `ifdef USE_convert_hex2ver
// `else
// `define NO_PLI 1
// `endif

`include "d:/altera/quartus/eda/sim_lib/altera_mf.v"
`include "d:/altera/quartus/eda/sim_lib/220model.v"
`include "d:/altera/quartus/eda/sim_lib/sgate.v"
`include "cpu_test_bench.v"
`include "cpu_mult_cell.v"
`include "cpu_oci_test_bench.v"
`include "cpu_jtag_debug_module_tck.v"
`include "cpu_jtag_debug_module_sysclk.v"
`include "cpu_jtag_debug_module_wrapper.v"
`include "cpu.v"
`include "pio_key.v"
`include "pio_left.v"
`include "pio_sw.v"
`include "pio_hex.v"
`include "pio_right.v"
`include "SRAM_16Bit_512K.v"
`include "sram_16bit_512k_0.v"
`include "pio_pingpong.v"

`timescale 1ns / 1ps

module test_bench 
;


  wire    [ 17: 0] SRAM_ADDR_from_the_sram_16bit_512k_0;
  wire             SRAM_CE_N_from_the_sram_16bit_512k_0;
  wire    [ 15: 0] SRAM_DQ_to_and_from_the_sram_16bit_512k_0;
  wire             SRAM_LB_N_from_the_sram_16bit_512k_0;
  wire             SRAM_OE_N_from_the_sram_16bit_512k_0;
  wire             SRAM_UB_N_from_the_sram_16bit_512k_0;
  wire             SRAM_WE_N_from_the_sram_16bit_512k_0;
  reg              clk;
  wire             in_port_to_the_pio_key;
  wire    [ 31: 0] in_port_to_the_pio_sw;
  wire    [ 15: 0] out_port_from_the_pio_hex;
  wire    [ 31: 0] out_port_from_the_pio_left;
  wire    [ 31: 0] out_port_from_the_pio_pingpong;
  wire    [ 31: 0] out_port_from_the_pio_right;
  reg              reset_n;


// <ALTERA_NOTE> CODE INSERTED BETWEEN HERE
//  add your signals and additional architecture here
// AND HERE WILL BE PRESERVED </ALTERA_NOTE>

  //Set us up the Dut
  hope DUT
    (
      .SRAM_ADDR_from_the_sram_16bit_512k_0      (SRAM_ADDR_from_the_sram_16bit_512k_0),
      .SRAM_CE_N_from_the_sram_16bit_512k_0      (SRAM_CE_N_from_the_sram_16bit_512k_0),
      .SRAM_DQ_to_and_from_the_sram_16bit_512k_0 (SRAM_DQ_to_and_from_the_sram_16bit_512k_0),
      .SRAM_LB_N_from_the_sram_16bit_512k_0      (SRAM_LB_N_from_the_sram_16bit_512k_0),
      .SRAM_OE_N_from_the_sram_16bit_512k_0      (SRAM_OE_N_from_the_sram_16bit_512k_0),
      .SRAM_UB_N_from_the_sram_16bit_512k_0      (SRAM_UB_N_from_the_sram_16bit_512k_0),
      .SRAM_WE_N_from_the_sram_16bit_512k_0      (SRAM_WE_N_from_the_sram_16bit_512k_0),
      .clk                                       (clk),
      .in_port_to_the_pio_key                    (in_port_to_the_pio_key),
      .in_port_to_the_pio_sw                     (in_port_to_the_pio_sw),
      .out_port_from_the_pio_hex                 (out_port_from_the_pio_hex),
      .out_port_from_the_pio_left                (out_port_from_the_pio_left),
      .out_port_from_the_pio_pingpong            (out_port_from_the_pio_pingpong),
      .out_port_from_the_pio_right               (out_port_from_the_pio_right),
      .reset_n                                   (reset_n)
    );

  initial
    clk = 1'b0;
  always
    #10 clk <= ~clk;
  
  initial 
    begin
      reset_n <= 0;
      #200 reset_n <= 1;
    end

endmodule


//synthesis translate_on